// Rysunek 23.26. PrimeCalculatorTask.java
// Obliczanie i wyświetlania pierwszych n liczb pierwszych
import java.util.Arrays;
import javafx.concurrent.Task;

public class PrimeCalculatorTask extends Task<Integer> {
   private final boolean[] primes; // Tablica typu boolean pozwalająca znajdować liczby pierwsze

   // Konstruktor
   public PrimeCalculatorTask(int max) {
      primes = new boolean[max]; 
      Arrays.fill(primes, true); // Inicjalizacja wszystkich elementów na wartość true
   } 

   // Długo działający kod uruchamiany w wątku roboczym
   @Override
   protected Integer call() {
      int count = 0; // Liczba znalezionych liczb pierwszych

      // Zaczynamy od indeksu 2 (pierwsza liczba pierwsza), przechodzimy
      // przez następne wartości i ustawiamy na false wielokrotności i
      for (int i = 2; i < primes.length; i++) {
         if (isCancelled()) { // Jeśli anulowano obliczenia...
            updateMessage("Anulowano");
            return 0;
         }
         else { 
            try { 
               Thread.sleep(10); // Spowolnij wątek
            }  
            catch (InterruptedException ex) {
               updateMessage("Przerwano");
               return 0;
            } 

            updateProgress(i + 1, primes.length); 

            if (primes[i]) { //Wartość i jest liczbą pierwszą
               ++count;
               updateMessage(String.format("Znaleziono %d liczb pierwszych", count));
               updateValue(i); // Wynik pośredni

               // Eliminowanie wielokrotności i
               for (int j = i + i; j < primes.length; j += i) {
                  primes[j] = false; // Wartość i nie jest liczbą pierwszą
               }
            } 
         }  
      } 
      
      return 0;   
   } 
} 

/*************************************************************************
* (C) Copyright 1992-2015 by Deitel & Associates, Inc. and               *
* Pearson Education, Inc. All Rights Reserved.                           *
*                                                                        *
* DISCLAIMER: The authors and publisher of this book have used their     *
* best efforts in preparing the book. These efforts include the          *
* development, research, and testing of the theories and programs        *
* to determine their effectiveness. The authors and publisher make       *
* no warranty of any kind, expressed or implied, with regard to these    *
* programs or to the documentation contained in these books. The authors *
* and publisher shall not be liable in any event for incidental or       *
* consequential damages in connection with, or arising out of, the       *
* furnishing, performance, or use of these programs.                     *
*************************************************************************/