// Rysunek 20.7. Stack.java
// Deklaracja klasy uogólnionej Stack
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class Stack<E> {
   private final ArrayList<E> elements; // ArrayList przechowuje elementy stosu

   // Konstruktor bezargumentowy tworzy stos o domyślnym rozmiarze
   public Stack() {
      this(10); // Domyślny rozmiar stosu
   }
   
   // Konstruktor tworzy stos o określonym rozmiarze
   public Stack(int capacity) {
      int initCapacity = capacity > 0 ? capacity : 10; // Walidacja
      elements = new ArrayList<E>(initCapacity); // Tworzenie ArrayList
   } 

   // Umieszczenie elementu na stosie
   public void push(E pushValue) {
      elements.add(pushValue); // Umieszczenie pushValue w Stack
   } 

   // Zwróć element z wierzchołka, jeśli istnieje; w przeciwnym razie zgłoś wyjątek
   public E pop() {
      if (elements.isEmpty()) { // Jeśli stos jest pusty
         throw new NoSuchElementException("Stos jest pusty, nie można nic zwrócić");
      } 

      // Usuń i zwróć wierzchołek stosu
      return elements.remove(elements.size() - 1); 
   } 
} 

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/