// Rysunek 18.20. FractalController.java
// Rysowanie pióra Lo z wykorzystaniem rekurencji
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;    

public class FractalController {
   // Stałe 
   private static final int MIN_LEVEL = 0;
   private static final int MAX_LEVEL = 15;

   // Zmienne instyancji związane z komponentami GUI.
   @FXML private Canvas canvas;
   @FXML private ColorPicker colorPicker;
   @FXML private Label levelLabel;

   // Inne zmienne instancji.
   private Color currentColor = Color.BLUE;
   private int level = MIN_LEVEL; // Początkowy poziom.
   private GraphicsContext gc; // Wykorzystywane do rysowania na Canvas.

   // Inicjalizacja kontrolera
   public void initialize() {
      levelLabel.setText("Poziom: " + level);
      colorPicker.setValue(currentColor); // Zacznij od purpurowego.
      gc = canvas.getGraphicsContext2D(); // Pobierz GraphicsContext.
      drawFractal();
   }
   
   // Ustaw currentColor, gdy użytkownik wybierze nowy kolor.
   @FXML
   void colorSelected(ActionEvent event) {
      currentColor = colorPicker.getValue(); // Obierz nowy obiekt Color.
      drawFractal();
   }

   // Zmniejsz poziom i ponownie narysuj fraktal.
   @FXML
   void decreaseLevelButtonPressed(ActionEvent event) {
      if (level > MIN_LEVEL) {
         --level;
         levelLabel.setText("Poziom: " + level);
         drawFractal();
      }
   }

   // Zwiększ poziom i ponownie narysuj fraktal.
   @FXML
   void increaseLevelButtonPressed(ActionEvent event) {
      if (level < MAX_LEVEL) {
         ++level;
         levelLabel.setText("Poziom: " + level);
         drawFractal();
      }
   }

   // Wyczyść Canvas, ustaw kolor rysowania i narysuj fraktal.
   private void drawFractal() {
      gc.clearRect(0, 0, canvas.getWidth(), canvas.getHeight());
      gc.setStroke(currentColor);
      drawFractal(level, 40, 40, 350, 350); 
   }

   // Rysuj fraktal rekurencyjnie.
   public void drawFractal(int level, int xA, int yA, int xB, int yB) {
      // Przypadek bazowy rysuje linię między dwoma podanymi punktami.
      if (level == 0) {
         gc.strokeLine(xA, yA, xB, yB);
      }
      else { // Krok rekurencyjny -- określa nowe punkty, rysuje następny poziom.
         // Określ środek między (xA, yA) i (xB, yB)
         int xC = (xA + xB) / 2;
         int yC = (yA + yB) / 2;

         // Oblicz czwarty punkt (xD, yD), który rysuje 
         // trójkąt równoramienny między (xA, yA) i (xC, yC),
         // a kąt prosty znajduje się w wierzchołku (xD, yD).
         int xD = xA + (xC - xA) / 2 - (yC - yA) / 2;
         int yD = yA + (yC - yA) / 2 + (xC - xA) / 2;
         
         // Rekurencyjnie rysuj fraktale.
         drawFractal(level - 1, xD, yD, xA, yA);
         drawFractal(level - 1, xD, yD, xC, yC);
         drawFractal(level - 1, xD, yD, xB, yB);  
      } 
   } 

   public static void selectionSort(int[] data) {
      // Przejście w pętli przez data.length - 1.      
      for (int i = 0; i < data.length - 1; i++) {
         int smallest = i; // Pierwszy indeks pozostałej części tablicy.

         // Przejdź w pętli, aby znaleźć indeks najmniejszego elementu.
         for (int index = i + 1; index < data.length; index++) {
            if (data[index] < data[smallest]) {
               smallest = index;                                        
             }                                                                 
         }                               
                                                                        
         swap(data, i, smallest); // Zamień najmniejszy element na pozycję.
      }                                                                 
   } 

   // Metoda pomocnicza zamieniające wartości dwóch elementów.
   private static void swap(int[] data, int first, int second) {
      int temporary = data[first]; // Zapamiętaj pierwszą wartość w zmiennej tymczasowej.
      data[first] = data[second]; // Zamień pierwszą z drugą.
      data[second] = temporary; // Umieść pierwszą wartość w drugiej.
   } 
}

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
