// Rysunek 8.5. Time2.java
// Deklaracja klasy Time2 z przeciążonymi konstruktorami

public class Time2 {
   private int hour; // 0 - 23
   private int minute; // 0 - 59
   private int second; // 0 - 59

   // Konstruktor bezargumentowy Time2
   // inicjalizuje wszystkie zmienne wartością 0
   public Time2() {                                             
      this(0, 0, 0); // Wywołaj konstruktor trójargumentowy
   } 

   // Konstruktor Time2: przekazanie godziny, minuty i sekundy ustawiane domyślnie na 0
   public Time2(int hour) {                                               
      this(hour, 0, 0); // Wywołaj konstruktor trójargumentowy
   } 

   // Konstruktor Time2: przekazanie godzin i minut, sekundy ustawiane domyślnie na 0
   public Time2(int hour, int minute) {
      this(hour, minute, 0); // Wywołaj konstruktor trójargumentowy
   } 

   // Konstruktor Time2: przekazanie godzin, minut i sekund 
   public Time2(int hour, int minute, int second) {                    
      if (hour < 0 || hour >= 24) {
         throw new IllegalArgumentException("dopuszczalny zakres hour to 0-23");
      } 

      if (minute < 0 || minute >= 60) {
         throw new IllegalArgumentException("dopuszczalny zakres minute to 0-59");
      } 

      if (second < 0 || second >= 60) {
         throw new IllegalArgumentException("dopuszczalny zakres second to 0-59");
      } 

      this.hour = hour;
      this.minute = minute; 
      this.second = second; 
   } 

   // Konstruktor Time2: przekazanie innego obiektu Time2      
   public Time2(Time2 time) {                                   
      //  Wywołaj konstruktor trójargumentowy
      this(time.hour, time.minute, time.second);
   } 

   // Metody ustawiające
   // Ustawia czas na podstawie systemu uniwersalnego
   // Waliduje otrzymane dane
   public void setTime(int hour, int minute, int second) {
      if (hour < 0 || hour >= 24) {
         throw new IllegalArgumentException("dopuszczalny zakres hour to 0-23");
      } 

      if (minute < 0 || minute >= 60) {
         throw new IllegalArgumentException("dopuszczalny zakres minute to 0-59");
      } 

      if (second < 0 || second >= 60) {
         throw new IllegalArgumentException("dopuszczalny zakres second to 0-59");
      } 

      this.hour = hour;
      this.minute = minute; 
      this.second = second; 
   } 

   // Sprawdza i ustawia godzinę
   public void setHour(int hour) {
      if (hour < 0 || hour >= 24) {
         throw new IllegalArgumentException("dopuszczalny zakres hour to 0-23");
      }

      this.hour = hour;
   } 

   // Sprawdza i ustawia minuty
   public void setMinute(int minute) {
      if (minute < 0 || minute >= 60) {
         throw new IllegalArgumentException("dopuszczalny zakres minute to 0-59");
      }

      this.minute = minute; 
   } 

   // Sprawdza i ustawia sekundy
   public void setSecond(int second) {
      if (second < 0 || second >= 60) {
         throw new IllegalArgumentException("dopuszczalny zakres second to 0-59");
      }

      this.second = second;
   } 

   // Metody pobierające        
   // Pobiera godzinę      
   public int getHour() {return hour;}

   // Pobiera minuty  
   public int getMinute() {return minute;} 

   // Pobiera sekundy   
   public int getSecond() {return second;}   

   // Zamienia na tekst w formacie uniwersalnym (HH:MM:SS)
   public String toUniversalString() {
      return String.format(
         "%02d:%02d:%02d", getHour(), getMinute(), getSecond());
   } 

   // Zamienia na tekst w formacie 12-godzinnym (H:MM:SS AM lub PM)
   public String toString() {
      return String.format("%d:%02d:%02d %s", 
         ((getHour() == 0 || getHour() == 12) ? 12 : getHour() % 12),
         getMinute(), getSecond(), (getHour() < 12 ? "AM" : "PM"));
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
