// Rysunek 15.15. FileChooserTestController.java
// Wyświetla informacje o wybranym pliku lub folderze
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;

public class FileChooserTestController {
   @FXML private BorderPane borderPane;
   @FXML private Button selectFileButton;
   @FXML private Button selectDirectoryButton;
   @FXML private TextArea textArea;

   // Obsługuje zdarzenia selectFileButton
   @FXML
   private void selectFileButtonPressed(ActionEvent e) {
      // Skonfiguruj okno dialogowe umożliwiające wybór pliku
      FileChooser fileChooser = new FileChooser();               
      fileChooser.setTitle("Wybierz plik");

      // Wyświetla pliki w folderze, w którym została uruchomiona aplikacja
      fileChooser.setInitialDirectory(new File(".")); 

      // Wyświetl FileChooser
      File file = fileChooser.showOpenDialog(
         borderPane.getScene().getWindow());               

      // Przetwórz wybraną ścieżkę lub wyświetl komunikat
      if (file != null) {
         analyzePath(file.toPath());            
      }
      else {
         textArea.setText("Wybierz plik lub folder");
      }
   } 

   // Obsługuje zdarzenia selectDirectoryButton
   @FXML
   private void selectDirectoryButtonPressed(ActionEvent e) {
      // Skonfiguruj okno dialogowe umożliwiające wybór folderu
      DirectoryChooser directoryChooser = new DirectoryChooser();               
      directoryChooser.setTitle("Wybierz folder");

      // Wyświetla folder, w którym została uruchomiona aplikacja
      directoryChooser.setInitialDirectory(new File(".")); 

      // Wyświetl FileChooser
      File file = directoryChooser.showDialog(
         borderPane.getScene().getWindow());               

      // Przetwórz wybraną ścieżkę lub wyświetl komunikat
      if (file != null) {
         analyzePath(file.toPath());            
      }
      else {
         textArea.setText("Wybierz plik lub folder");
      }
   } 

   // Wyświetla informacje na temat pliku lub folderu wybranego przez użytkownika
   public void analyzePath(Path path) {
      try {
         // Jeśli ścieżka istnieje, wyświetl informacje o niej
         if (path != null && Files.exists(path)) {
            // Pobierz informacje
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("%s:%n", path.getFileName()));
            builder.append(String.format("%s folderem%n", 
               Files.isDirectory(path) ? "Jest" : "Nie jest"));
            builder.append(String.format("%s ścieżką bezwzględną%n", 
               path.isAbsolute() ? "Jest" : "Nie jest"));
            builder.append(String.format("Ostatnia modyfikacja: %s%n", 
               Files.getLastModifiedTime(path)));
            builder.append(String.format("Rozmiar: %s%n", Files.size(path)));
            builder.append(String.format("Ścieżka: %s%n", path));
            builder.append(String.format("Ścieżka bezwzględna: %s%n", 
               path.toAbsolutePath()));

            if (Files.isDirectory(path)) { // Wyświetl zawartość folderu
               builder.append(String.format("%nZawartość folderu:%n"));
               
               // Obiekt pozwalający przejść przez zawartość folderu
               DirectoryStream<Path> directoryStream = 
                  Files.newDirectoryStream(path);
      
               for (Path p : directoryStream) {
                  builder.append(String.format("%s%n", p));
               }
            }

            // Wyświetl informacje
            textArea.setText(builder.toString()); 
         } 
         else { // Ścieżka nie istnieje
            textArea.setText("Ścieżka nie istnieje");
         }   
      }
      catch (IOException ioException) {
         textArea.setText(ioException.toString());
      }
   } 
}


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
