// Rysunek 15.2. FileAndDirectoryInfo.java
// Klasa File używana do pobrania informacji o pliku lub folderze
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Scanner;

public class FileAndDirectoryInfo {
   public static void main(String[] args) throws IOException {
      Scanner input = new Scanner(System.in);

      System.out.println("Wpisz nazwę pliku lub folderu:");

      // Utwórz obiekt Path na podstawie informacji od użytkownika
      Path path = Paths.get(input.nextLine());

      if (Files.exists(path)) // Jeśli ścieżka istnieje, wyświetl informacje o niej
      {
         // Wyświetla informacje na temat pliku lub folderu
      	System.out.printf("%n%s istnieje%n", path.getFileName());
      	System.out.printf("%s folderem%n", 
      		Files.isDirectory(path) ? "Jest" : "Nie jest");
      	System.out.printf("%s ścieżką bezwzględną%n", 
      		path.isAbsolute() ? "Jest" : "Nie jest");
      	System.out.printf("Ostatnia modyfikacja: %s%n", 
      		Files.getLastModifiedTime(path));
      	System.out.printf("Rozmiar: %s%n", Files.size(path));
      	System.out.printf("Ścieżka: %s%n", path);
      	System.out.printf("Ścieżka bezwzględna: %s%n", path.toAbsolutePath());

         if (Files.isDirectory(path)) { // Wyświetl zawartość folderu
            System.out.printf("%nZawartość folderu:%n");
            
            // Obiekt pozwalający przejść przez zawartość folderu
            DirectoryStream<Path> directoryStream = 
               Files.newDirectoryStream(path);
   
            for (Path p : directoryStream)
               System.out.println(p);
         } 
      } 
      else { // Nie jest to plik ani folder, wyświetl informację o błędzie
         System.out.printf("%s nie istnieje%n", path);
      }   
   }
} // Koniec klasy FileAndDirectoryInfo


/*************************************************************************
* (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
* Pearson Education, Inc. All Rights Reserved.                           *
*                                                                        *
* DISCLAIMER: The authors and publisher of this book have used their     *
* best efforts in preparing the book. These efforts include the          *
* development, research, and testing of the theories and programs        *
* to determine their effectiveness. The authors and publisher make       *
* no warranty of any kind, expressed or implied, with regard to these    *
* programs or to the documentation contained in these books. The authors *
* and publisher shall not be liable in any event for incidental or       *
* consequential damages in connection with, or arising out of, the       *
* furnishing, performance, or use of these programs.                     *
*************************************************************************/