// Rysunek 13.17. ImageTextCell.java
// Własna fabryka komórek ListView, która wyświetla tekst i obrazek
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;

public class ImageTextCell extends ListCell<Book> {
   private VBox vbox = new VBox(8.0); // 8 punktów przerwy między kontrolkami
   private ImageView thumbImageView = new ImageView(); // Początkowo puste
   private Label label = new Label();

   // Konstruktor konfiguruje VBox, ImageView i Label
   public ImageTextCell() {
      vbox.setAlignment(Pos.CENTER); // Środkowanie VBox w poziomie

      thumbImageView.setPreserveRatio(true);
      thumbImageView.setFitHeight(100.0); // Miniaturka wysoka na 100 punktów
      vbox.getChildren().add(thumbImageView); // Dodanie do Vbox

      label.setWrapText(true); // Zawiń tekst, jeśli za długi
      label.setTextAlignment(TextAlignment.CENTER); // Środkuj tekst
      vbox.getChildren().add(label); // Dodanie do VBox

      setPrefWidth(USE_PREF_SIZE); // Użyj preferowanego rozmiaru dla szerokości komórek
   }

   // Wywoływane w celu skonfigurowania każdej własnej komórki ListView
   @Override 
   protected void updateItem(Book item, boolean empty) {
      // Wymagane, aby komórka wyświetliła się prawidłowo
      super.updateItem(item, empty);

      if (empty || item == null) {
         setGraphic(null); // Nic nie wyświetlaj
      }
      else {
         // Ustaw miniaturkę w ImageView.
         thumbImageView.setImage(new Image(item.getThumbImage()));
         label.setText(item.getTitle()); // Konfiguracja etykiety
         setGraphic(vbox); // Dołączenie własnego układu do komórki ListView
      }
   }
}

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
