// Rysunek 8.17. MyLine.java
// Klasa MyLine reprezentuje linię.
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;

public class MyLine {
   private double x1; // Współrzędna X pierwszego punktu.
   private double y1; // Współrzędna Y pierwszego punktu.
   private double x2; // Współrzędna X drugiego punktu.
   private double y2; // Współrzędna Y drugiego punktu.
   private Color strokeColor; // Kolor linii.

   // Konstruktor z wartościami wejściowymi.
   public MyLine(
      double x1, double y1, double x2, double y2, Color strokeColor) {

      this.x1 = x1; 
      this.y1 = y1; 
      this.x2 = x2; 
      this.y2 = y2; 
      this.strokeColor = strokeColor;
   } 
   
   // Rysowanie linii w konkretnym kolorze.
   public void draw(GraphicsContext gc) {
      gc.setStroke(strokeColor);
      gc.strokeLine(x1, y1, x2, y2);
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/