// Rysunek 8.7. Date.java 
// Deklaracja klasy Date.

public class Date {
   private int month; // 1-12
   private int day; // 1-31 ale z uwzględnieniem miesiąca
   private int year; // dowolny rok

   private static final int[] daysPerMonth = 
      {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
   
   // Konstruktor: potwierdź poprawność misiąca i dnia na podstawie roku.
   public Date(int month, int day, int year) {
      // Sprawdź, czy miesiąc znajduje się w obsługiwanym zakresie.
      if (month <= 0 || month > 12) {
         throw new IllegalArgumentException(
            "month (" + month + ") musi się znajdować w zakresie 1-12");
      }

      // Sprawdź, czy dzień znajduje się w zakresie dla danego miesiąca.
      if (day <= 0 || 
         (day > daysPerMonth[month] && !(month == 2 && day == 29))) {
         throw new IllegalArgumentException("day (" + day + 
            ") poza zakresem dla danego miesiąca i roku");
      }

      // Sprawdź rok przestępny, jeśli miesiącem jest luty a dniem 29.
      if (month == 2 && day == 29 && !(year % 400 == 0 || 
           (year % 4 == 0 && year % 100 != 0))) {
         throw new IllegalArgumentException("day (" + day +
            ") poza zakresem dla danego miesiąca i roku");
      }
   
      this.month = month;
      this.day = day;
      this.year = year;

      System.out.printf("Konstrukcja obiektu Date dla daty %s%n", this);
   } 
   
   // Zwraca obiekt String w postaci dzień/miesiąc/rok.
   public String toString() {
      return String.format("%d/%d/%d", day, month, year); 
   } 
} 



/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
