// Rysunek 8.6. Time2Test.java
// Przeciążone operatory służące do inicjalizacji obiektów Time2.

public class Time2Test {
   public static void main(String[] args) {
      Time2 t1 = new Time2(); // 00:00:00          
      Time2 t2 = new Time2(2); // 02:00:00         
      Time2 t3 = new Time2(21, 34); // 21:34:00    
      Time2 t4 = new Time2(12, 25, 42); // 12:25:42
      Time2 t5 = new Time2(t4); // 12:25:42        

      System.out.println("Utworzono za pomocą:");
      displayTime("t1: wszystkie argumenty domyślne", t1);
      displayTime("t2: podano godzinę; domyślne minuty i sekundy", t2);
      displayTime("t3: podano godzinę i minuty; sekundy domyślne", t3);
      displayTime("t4: podano godzinę, minuty i sekundy", t4);
      displayTime("t5: wskazano obiekt t4 klasy Time2", t5);

      // Próba inicjalizacji t6 z niepoprawnymi wartościami.
      try {
         Time2 t6 = new Time2(27, 74, 99); // Niepoprawne wartości.
      } 
      catch (IllegalArgumentException e) {
         System.out.printf("%nWyjątek w trakcie inicjalizacji t6: %s%n",
            e.getMessage());
      } 
   } 

   // Wyświetla obiekt Time2 w formacie 24- i 12-godzinnym.
   private static void displayTime(String header, Time2 t) {
      System.out.printf("%s%n   %s%n   %s%n",
         header, t.toUniversalString(), t.toString());
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
