// Rysunek 8.4. ThisTest.java
// Referencja this używana jawnie i niejawnie do odniesienia się do składowych obiektu.

public class ThisTest {
   public static void main(String[] args) {
      SimpleTime time = new SimpleTime(15, 30, 19);
      System.out.println(time.buildString());
   } 
} 

// Klasa SimpleTime ilustruje użycie referencji this.
class SimpleTime {
   private int hour; // 0-23
   private int minute; // 0-59
   private int second; // 0-59 

   // Jeśli nazwy parametrów konstruktora są takie same
   // jak nazwy składowych klasy, trzeba użyć referencji this,
   // aby dokonać rozróżnienia między nazwą parametru i składową.
   public SimpleTime(int hour, int minute, int second) {
      this.hour = hour; // Ustaw składową hour obiektu.        
      this.minute = minute; // Ustaw składową minute obiektu.      
      this.second = second; // Ustaw składową second obiektu.      
   }

   // Użyj jawnego i niejawnego this w wywołaniu toUniversalString
   public String buildString() {
      return String.format("%24s: %s%n%24s: %s", 
         "this.toUniversalString()", this.toUniversalString(),
         "toUniversalString()", toUniversalString());
   } 

   // Zamień na tekst w formacie uniwersalnym (HH:MM:SS).
   public String toUniversalString() {
      // Referencja this nie jest wymagana, aby w tym miejscu skorzystać
      // ze składowych, ponieważ metoda nie zawiera zmiennych lokalnych
      // o takich samych nazwach jak składowe klasy.
      return String.format("%02d:%02d:%02d", 
         this.hour, this.minute, this.second);
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
