// Rysunek 5.27. DrawShapesController.java
// Użycie strokeRect i strokeOval do rysowania prostokątów i owali
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;

public class DrawShapesController { 
   @FXML private Canvas canvas;
   
   // Gdy użytkownik kliknie przycisk Rysuj prostokąty, wywołaj draw dla prostokątów
   @FXML
   void drawRectanglesButtonPressed(ActionEvent event) {
      draw("prostokąty");
   }

   // Gdy użytkownik kliknie przycisk Rysuj owale, wywołaj draw dla owali
   @FXML
   void drawOvalsButtonPressed(ActionEvent event) {
      draw("owale");
   }

   // Rysuje prostokąty lub owale w zależności od tego, który przycisk kliknięto
   public void draw(String choice) {
      // Pobierz GraphicsContext, który służy do rysowania na obiekcie Canvas
      GraphicsContext gc = canvas.getGraphicsContext2D();

      // Wyczyść kanwę dla następnego zbioru kształtów
      gc.clearRect(0, 0, canvas.getWidth(), canvas.getHeight());

      int step = 10;

      // Narysuj 10 nakładających się na siebie kształtów
      for (int i = 0; i < 12; i++) {
         // Wybierz kształt na podstawie kliknięcia przez użytkownika
         switch (choice) {
            case "prostokąty": // Rysuj prostokąty
               //gc.strokeRect(10 + i * step, 10 + i * step, 
                  //90 + i * step, 90 + i * step);
               break;
            case "owale": // Rysuj owale.
               gc.strokeOval(10 + i * step, 10 + i * step, 
                  90 + i * step, 90 + i * step);
               break;
         } 
      } 
   }
}

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
