/******************************************************************************
 *  Kompilacja:  javac ThreeSum.java
 *  Wykonanie:    java ThreeSum < input.txt
 *                java Generator n | java ThreeSum
 *  Pliki z danymi:   http://www.cs.princeton.edu/introcs/41analysis/8ints.txt
 *                http://www.cs.princeton.edu/introcs/41analysis/1Kints.txt
 *                http://www.cs.princeton.edu/introcs/41analysis/2Kints.txt
 *                http://www.cs.princeton.edu/introcs/41analysis/4Kints.txt
 *                http://www.cs.princeton.edu/introcs/41analysis/8Kints.txt
 *                http://www.cs.princeton.edu/introcs/41analysis/16Kints.txt
 *                http://www.cs.princeton.edu/introcs/41analysis/32Kints.txt
 *                http://www.cs.princeton.edu/introcs/41analysis/64Kints.txt
 *                http://www.cs.princeton.edu/introcs/41analysis/128Kints.txt
 *
 *  Program działający w czasie sześciennym. Wczytuje n liczb całkowitych
 *  i zlicza trójki dające w sumie 0.
 *
 *  % java ThreeSum < 8ints.txt 
 *  4
 *  30 -30 0
 *  30 -20 -10
 *  -30 -10 40
 *  -10 0 10
 *
 *  % java ThreeSum < 1Kints.txt
 *  0
 *
 *
 *  Ograniczenia
 *  -----------
 *     - ignorowanie jest przepełnienie typu integer
 *
 *
 ******************************************************************************/

public class ThreeSum {

    // wyświetla różne trójki (i, j, k), dla których a[i] + a[j] + a[k] = 0
    public static void printAll(int[] a) {
        int n = a.length;
        for (int i = 0; i < n; i++) {
            for (int j = i+1; j < n; j++) {
                for (int k = j+1; k < n; k++) {
                    if (a[i] + a[j] + a[k] == 0) {
                        StdOut.println(a[i] + " " + a[j] + " " + a[k]);
                    }
                }
            }
        }
    } 

    // zwraca liczbę różnych trójek (i, j, k), dla których a[i] + a[j] + a[k] = 0
    public static int count(int[] a) {
        int n = a.length;
        int count = 0;
        for (int i = 0; i < n; i++) {
            for (int j = i+1; j < n; j++) {
                for (int k = j+1; k < n; k++) {
                    if (a[i] + a[j] + a[k] == 0) {
                        count++;
                    }
                }
            }
        }
        return count;
    } 

    public static void main(String[] args)  { 
        int[] a = StdIn.readAllInts();
        Stopwatch timer = new Stopwatch();
        int count = count(a);
        StdOut.println("czas = " + timer.elapsedTime());
        StdOut.println(count);
    } 
} 