/******************************************************************************
 *  Kompilacja:  javac SmallWorld.java
 *  Wykonanie:    java SmallWorld filename delimiter
 *  Zależności: Graph.java PathFinder.java StdOut.java In.java
 *  Pliki z danymi:   https://introcs.cs.princeton.edu/45graph/tinyGraph.txt
 *
 *  %  java SmallWorld tinyGraph.txt " "
 *  liczba wierzchołków      =       5
 *  liczba krawędzi          =       7
 *  średni stopień           =   2.800
 *  maksymalny stopień       =       4
 *  średnia długość ścieżki  =   1.300
 *  współczynnik skupienia   =   0.767
 *
 ******************************************************************************/

public class SmallWorld {

    public static double averageDegree(Graph G) {
        return (double) 2 * G.E() / G.V();
    }

    public static double averagePathLength(Graph G) {
        int sum = 0;
        for (String v : G.vertices()) {
            PathFinder pf = new PathFinder(G, v);
            for (String w : G.vertices())
                sum += pf.distanceTo(w);
        }
        return (double) sum / (G.V() * (G.V() - 1));
    }


    // Oblicza współczynnik skupienia
    public static double clusteringCoefficient(Graph G) {
        double total = 0.0;
        for (String v : G.vertices()) {
            // Wyznaczanie łącznego współczynnika skupienia dla wierzchołka v.
            int possible = G.degree(v) * (G.degree(v) - 1);
            int actual = 0;
            for (String u : G.adjacentTo(v)) {
                for (String w : G.adjacentTo(v)) {
                    if (G.hasEdge(u, w))
                        actual++;
                }
            }
            if (possible > 0) {
                total += 1.0 * actual / possible;
            }
        }
        return total / G.V();
    }

    // Zwraca maksymalny stopień wierzchołków grafu
    public static int maxDegree(Graph G) {
        int max = 0;
        for (String v : G.vertices()) {
            if (G.degree(v) > max)
                max = G.degree(v);
        }
        return max;
    }

    public static void main(String[] args) {
        String filename  = args[0];
        String delimiter = args[1];
        Graph graph = new Graph(filename, delimiter);

        StdOut.printf("liczba wierzchołków      = %7d\n", graph.V());
        StdOut.printf("liczba krawędzi          = %7d\n", graph.E());
        StdOut.printf("średni stopień           = %7.3f\n", averageDegree(graph));
        StdOut.printf("maksymalny stopień       = %7d\n",   maxDegree(graph));
        StdOut.printf("średnia długość ścieżki  = %7.3f\n", averagePathLength(graph));
        StdOut.printf("współczynnik skupienia   = %7.3f\n", clusteringCoefficient(graph));

    }
}