/******************************************************************************
 *  Kompilacja:  javac SmallWorld.java
 *  Wykonanie:    java SmallWorld filename delimiter
 *  Zależności: Graph.java PathFinder.java StdOut.java In.java
 *  Pliki z danymi:   https://introcs.cs.princeton.edu/45graph/tinyMovies.txt
 *                https://introcs.cs.princeton.edu/45graph/moviesG.txt
 *
 *  % java Performer tinyMovies.txt "/"
 *  liczba wierzchołków      =       5
 *  średni stopień           =   2.800
 *  średnia długość ścieżki  =   1.300
 *  współczynnik skupienia   =   0.767
 *
 *  % java Performer moviesG.txt "/"
 *  [ po długim czasie ]
 *  liczba wierzchołków      =   19044
 *  średni stopień           = 148.688
 *  średnia długość ścieżki  =   3.494
 *  współczynnik skupienia   =   0.911
 *
 ******************************************************************************/

public class Performer {

    public static void main(String[] args) {
        String filename  = args[0];
        String delimiter = args[1];
        Graph graph = new Graph();
        In in = new In(filename);
        while (in.hasNextLine()) {
            String line = in.readLine();
            String[] names = line.split(delimiter);
            for (int i = 1; i < names.length; i++) {
                for (int j = i+1; j < names.length; j++) {
                    graph.addEdge(names[i], names[j]);
                }
            }
        }

        double degree  = SmallWorld.averageDegree(graph);
        double length  = SmallWorld.averagePathLength(graph);
        double cluster = SmallWorld.clusteringCoefficient(graph);
        StdOut.printf("liczba wierzchołków      = %7d\n", graph.V());
        StdOut.printf("średni stopień           = %7.3f\n", degree);
        StdOut.printf("średnia długość ścieżki  = %7.3f\n", length);
        StdOut.printf("współczynnik skupienia   = %7.3f\n", cluster);
    }
}