/******************************************************************************
 *  Kompilacja:  javac LinkedStackOfStrings.java
 *  Wykonanie:    java LinkedStackOfStrings
 *  Pliki z danymi:   https://introcs.cs.princeton.edu/43stack/tobe.txt
 *
 *  Stos ciągów znaków zaimplementowany za pomocą listy połączonej.
 *  
 *  % more tobe.txt 
 *  to be or not to - be - - that - - - is 
 * 
 *  % java LinkedStackOfStrings < tobe.txt 
 *  to be not that or be
 *  
 ******************************************************************************/

import java.util.NoSuchElementException;

public class LinkedStackOfStrings {
    private int n;          // wielkość stosu
    private Node first;     // wierzchołek stosu

    // klasa pomocnicza Node
    private class Node {
        private String item;
        private Node next;
    }

    // czy stos jest pusty?
    public boolean isEmpty() {
        return first == null;
    }

    // liczba elementów na stosie
    public int size() {
        return n;
    }


    // dodaje element do stosu
    public void push(String item) {
        Node oldfirst = first;
        first = new Node();
        first.item = item;
        first.next = oldfirst;
        n++;
    }

    // usuwa i zwraca ostatnio dodany element
    public String pop() {
        if (isEmpty()) throw new NoSuchElementException("brak elementu na stosie");
        String item = first.item;      // zapisuje zwracany element
        first = first.next;            // usuwa pierwszy węzeł
        n--;
        return item;                   // zwraca zapisany element
    }


    // klient testowy
    public static void main(String[] args) {
        LinkedStackOfStrings stack = new LinkedStackOfStrings();
        while (!StdIn.isEmpty()) {
            String item = StdIn.readString();
            if (!item.equals("-"))     stack.push(item); 
            else if (stack.isEmpty())  StdOut.println("BŁĘDNE DANE WEJŚCIOWE"); 
            else                       StdOut.print(stack.pop());
        } 
    } 


}