/******************************************************************************
 *  Kompilacja:  javac Evaluate.java
 *  Wykonanie:    java Evaluate
 *  Zależności: Stack.java
 *
 *  Wartościuje wyrażenia arytmetyczne z użyciem algorytmu Dijkstry
 *  wykorzystującego dwa stosy.
 *
 *  % java Evaluate 
 *  ( 1 + ( ( 2 + 3 ) * ( 4 * 5 ) ) ) 
 *  101.0 
 *
 *  % java Evaulate
 *  ( ( 1 + sqrt ( 5 ) ) / 2.0 ) 
 *  1.618033988749895
 *
 *
 *
 *  Co zaskakujące, algorytm Dijkstry zwraca ten sam wynik,
 *  jeśli każdy operator umieścisz *po* dwóch operandach
 *  zamiast *między* nimi.
 *
 *  % java Evaluate
 *  ( 1 ( ( 2 3 + ) ( 4 5 * ) * ) + ) 
 *  101.0
 *
 *  Ponadto w takich wyrażeniach nawiasy są zbędne!
 *  Po ich usunięciu otrzymasz wyrażenie postfiksowe.
 *  1 2 3 + 4 5 * * + 
 * 
 *
 ******************************************************************************/

public class Evaluate {
    public static void main(String[] args) { 
        Stack<String> ops  = new Stack<String>();
        Stack<Double> vals = new Stack<Double>();

        while (!StdIn.isEmpty()) {
            String s = StdIn.readString();
            if      (s.equals("("))               ;
            else if (s.equals("+"))    ops.push(s);
            else if (s.equals("-"))    ops.push(s);
            else if (s.equals("*"))    ops.push(s);
            else if (s.equals("/"))    ops.push(s);
            else if (s.equals("sqrt")) ops.push(s);
            else if (s.equals(")")) {
                String op = ops.pop();
                double v = vals.pop();
                if      (op.equals("+"))    v = vals.pop() + v;
                else if (op.equals("-"))    v = vals.pop() - v;
                else if (op.equals("*"))    v = vals.pop() * v;
                else if (op.equals("/"))    v = vals.pop() / v;
                else if (op.equals("sqrt")) v = Math.sqrt(v);
                vals.push(v);
            }
            else vals.push(Double.parseDouble(s));
        }
        StdOut.println(vals.pop());
    }
}