
public class PotentialGene
{
   public static boolean isPotentialGene(String dna)
   {
      // Długość jest wielokrotnością 3.
      if (dna.length() % 3 != 0) return false;
      // Rozpoczyna się od początkowego kodonu.
      if (!dna.startsWith("ATG")) return false;
      // Brak końcowych kodonów wewnątrz.
      for (int i = 3; i < dna.length() - 3; i++)
      {
         if (i % 3 == 0)
         {
            String codon = dna.substring(i, i+3);
            if (codon.equals("TAA")) return false;
            if (codon.equals("TAG")) return false;
            if (codon.equals("TGA")) return false;
         }
      }
      // Kończy się kodonem końcowym.
      if (dna.endsWith("TAA")) return true;
      if (dna.endsWith("TAG")) return true;
      if (dna.endsWith("TGA")) return true;
      return false;
   }
}
