<?php
/* Copyright 2011 Jonathan LeBlanc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * Class: PubSubHubbub Publisher
 * Description: Umożliwia publikację nowych aktualizacji w hubie
 */
class Publisher{
    private $regex_url = '|^https?://|i';       // prosty mechanizm weryfikacji URL-a
    private $hub = '';                          // adres URL huba
    
    // Konstruktor zapisujący hub i adresy URL wywolań zwrotnych dla subskrybenta
    public function __construct($hub){
        if (preg_match($this->regex_url, $hub)){ $this->hub = $hub; }
        else{ throw new Exception('Nieprawidłowy adres URL huba'); }
    }
    
    // Konstruuje żądanie dodania lub usunięcia subskrypcji w hubie
    public function publish($feeds){
        // Ustawia łańcuch POST z odpowiednim trybem
        $post_string = 'hub.mode=publish';
        
        // Przetwarza w pętli wszystkie przekazane kanały
        foreach ($feeds as $feed){
            // Jeśli kanał jest prawidłowy, dodaje go do łańcucha POST
            if (preg_match($this->regex_url, $feed)){
                $post_string .= '&hub.url=' . urlencode($feed);
            } else {
                throw new Exception('Nieprawidłowy adres URL kanału');
            }
        }
        
        // Przygotowuje żądanie cURL
        $ch = curl_init($this->hub);
        $options = array(
            CURLOPT_HEADER => true,
            CURLINFO_HEADER_OUT => true,
            CURLOPT_VERBOSE => true,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POSTFIELDS => $post_string,
            CURLOPT_CUSTOMREQUEST => 'POST'
        );
        curl_setopt_array($ch, $options);
            
        // Wysyła żądanie do huba
        $response = curl_exec($ch);
        curl_close($ch);
            
        // Zwraca odpowiedź
        return $response;
    }
}
?>