/* Copyright (C) 1999 Lucent Technologies */
/* Fragment ksiki The Practice of Programming */
/* Briana W. Kernighana i Roba Pike'a */

#include <stdio.h>
#include <stdlib.h>
#include "eprintf.h"
#include <stdarg.h>
#include <string.h>
#include <errno.h>

static char *name = NULL;  /* Nazwa programu dla komunikatw */

/* eprintf: drukuje komunikat o bdzie i koczy dziaanie */
void eprintf(char *fmt, ...)
{
	va_list args;

	fflush(stdout);
	if (progname() != NULL)
		fprintf(stderr, "%s: ", progname());

	va_start(args, fmt);
	vfprintf(stderr, fmt, args);
	va_end(args);

	if (fmt[0] != '\0' && fmt[strlen(fmt)-1] == ':')
		fprintf(stderr, " %s", strerror(errno));
	fprintf(stderr, "\n");
	exit(2); /* Typowa warto oznaczajca bd wykonywania */
}

/* weprintf: drukuje ostrzeenie */
void weprintf(char *fmt, ...)
{
	va_list args;

	fflush(stdout);
	fprintf(stderr, "Ostrzeenie: ");
	if (progname() != NULL)
		fprintf(stderr, "%s: ", progname());
	va_start(args, fmt);
	vfprintf(stderr, fmt, args);
	va_end(args);
	if (fmt[0] != '\0' && fmt[strlen(fmt)-1] == ':')
		fprintf(stderr, " %s\n", strerror(errno));
	else
		fprintf(stderr, "\n");
}

/* emalloc: alokuje pami i zgasza bd, jeli wystpi */
void *emalloc(size_t n)
{
	void *p;

	p = malloc(n);
	if (p == NULL)
		eprintf("Alokacja %u bajtw zakoczona niepowodzeniem:", n);
	return p;
}

/* erealloc: realokuje pami i zgasza bd, jeli wystpi */
void *erealloc(void *vp, size_t n)
{
	void *p;

	p = realloc(vp, n);
	if (p == NULL)
		eprintf("Realokacja %u bajtw zakoczona niepowodzeniem:", n);
	return p;
}

/* estrdup: tworzy duplikat acucha i zgasza bd, jeli wystpi */
char *estrdup(char *s)
{
	char *t;

	t = (char *) malloc(strlen(s)+1);
	if (t == NULL)
		eprintf("Wykonanie funkcji estrdup(\"%.20s\") nie powiodo si:", s);
	strcpy(t, s);
	return t;
}

/* progname: zwraca zapisan nazw programu */
char *progname(void)
{
	return name;
}

/* setprogname: ustawia zapisan nazw programu */
void setprogname(char *str)
{
	name = estrdup(str);
}
