/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.util.Util;

public class MultiClassKey {
    private Class<?> first;
    private Class<?> second;
    private Class<?> third;

    public MultiClassKey() {
    }

    public MultiClassKey(@NonNull Class<?> first, @NonNull Class<?> second) {
        this.set(first, second);
    }

    public MultiClassKey(@NonNull Class<?> first, @NonNull Class<?> second, @Nullable Class<?> third) {
        this.set(first, second, third);
    }

    public void set(@NonNull Class<?> first, @NonNull Class<?> second) {
        this.set(first, second, null);
    }

    public void set(@NonNull Class<?> first, @NonNull Class<?> second, @Nullable Class<?> third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public String toString() {
        return "MultiClassKey{first=" + this.first + ", second=" + this.second + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiClassKey that = (MultiClassKey)o;
        if (!this.first.equals(that.first)) {
            return false;
        }
        if (!this.second.equals(that.second)) {
            return false;
        }
        return Util.bothNullOrEqual(this.third, that.third);
    }

    public int hashCode() {
        int result = this.first.hashCode();
        result = 31 * result + this.second.hashCode();
        result = 31 * result + (this.third != null ? this.third.hashCode() : 0);
        return result;
    }
}

