/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Pools;
import com.bumptech.glide.Registry;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoader;
import com.bumptech.glide.util.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MultiModelLoaderFactory {
    private static final Factory DEFAULT_FACTORY = new Factory();
    private static final ModelLoader<Object, Object> EMPTY_MODEL_LOADER = new EmptyModelLoader();
    private final List<Entry<?, ?>> entries = new ArrayList();
    private final Factory factory;
    private final Set<Entry<?, ?>> alreadyUsedEntries = new HashSet();
    private final Pools.Pool<List<Throwable>> throwableListPool;

    public MultiModelLoaderFactory(@NonNull Pools.Pool<List<Throwable>> throwableListPool) {
        this(throwableListPool, DEFAULT_FACTORY);
    }

    @VisibleForTesting
    MultiModelLoaderFactory(@NonNull Pools.Pool<List<Throwable>> throwableListPool, @NonNull Factory factory) {
        this.throwableListPool = throwableListPool;
        this.factory = factory;
    }

    synchronized <Model, Data> void append(@NonNull Class<Model> modelClass, @NonNull Class<Data> dataClass, @NonNull ModelLoaderFactory<? extends Model, ? extends Data> factory) {
        this.add(modelClass, dataClass, factory, true);
    }

    synchronized <Model, Data> void prepend(@NonNull Class<Model> modelClass, @NonNull Class<Data> dataClass, @NonNull ModelLoaderFactory<? extends Model, ? extends Data> factory) {
        this.add(modelClass, dataClass, factory, false);
    }

    private <Model, Data> void add(@NonNull Class<Model> modelClass, @NonNull Class<Data> dataClass, @NonNull ModelLoaderFactory<? extends Model, ? extends Data> factory, boolean append) {
        Entry<? extends Model, ? extends Data> entry = new Entry<Model, Data>(modelClass, dataClass, factory);
        this.entries.add(append ? this.entries.size() : 0, entry);
    }

    @NonNull
    synchronized <Model, Data> List<ModelLoaderFactory<? extends Model, ? extends Data>> replace(@NonNull Class<Model> modelClass, @NonNull Class<Data> dataClass, @NonNull ModelLoaderFactory<? extends Model, ? extends Data> factory) {
        List<ModelLoaderFactory<? extends Model, ? extends Data>> removed = this.remove(modelClass, dataClass);
        this.append(modelClass, dataClass, factory);
        return removed;
    }

    @NonNull
    synchronized <Model, Data> List<ModelLoaderFactory<? extends Model, ? extends Data>> remove(@NonNull Class<Model> modelClass, @NonNull Class<Data> dataClass) {
        ArrayList<ModelLoaderFactory<Model, Data>> factories = new ArrayList<ModelLoaderFactory<Model, Data>>();
        Iterator<Entry<?, ?>> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry<Model, Model> entry = iterator.next();
            if (!entry.handles(modelClass, dataClass)) continue;
            iterator.remove();
            factories.add(this.getFactory(entry));
        }
        return factories;
    }

    @NonNull
    synchronized <Model> List<ModelLoader<Model, ?>> build(@NonNull Class<Model> modelClass) {
        try {
            ArrayList loaders = new ArrayList();
            for (Entry<Model, Model> entry : this.entries) {
                if (this.alreadyUsedEntries.contains(entry) || !entry.handles(modelClass)) continue;
                this.alreadyUsedEntries.add(entry);
                loaders.add(this.build(entry));
                this.alreadyUsedEntries.remove(entry);
            }
            return loaders;
        }
        catch (Throwable t) {
            this.alreadyUsedEntries.clear();
            throw t;
        }
    }

    @NonNull
    synchronized List<Class<?>> getDataClasses(@NonNull Class<?> modelClass) {
        ArrayList result = new ArrayList();
        for (Entry<?, ?> entry : this.entries) {
            if (result.contains(entry.dataClass) || !entry.handles(modelClass)) continue;
            result.add(entry.dataClass);
        }
        return result;
    }

    @NonNull
    public synchronized <Model, Data> ModelLoader<Model, Data> build(@NonNull Class<Model> modelClass, @NonNull Class<Data> dataClass) {
        try {
            ArrayList loaders = new ArrayList();
            boolean ignoredAnyEntries = false;
            for (Entry<Model, Model> entry : this.entries) {
                if (this.alreadyUsedEntries.contains(entry)) {
                    ignoredAnyEntries = true;
                    continue;
                }
                if (!entry.handles(modelClass, dataClass)) continue;
                this.alreadyUsedEntries.add(entry);
                loaders.add(this.build(entry));
                this.alreadyUsedEntries.remove(entry);
            }
            if (loaders.size() > 1) {
                return this.factory.build(loaders, this.throwableListPool);
            }
            if (loaders.size() == 1) {
                return (ModelLoader)loaders.get(0);
            }
            if (ignoredAnyEntries) {
                return MultiModelLoaderFactory.emptyModelLoader();
            }
            throw new Registry.NoModelLoaderAvailableException(modelClass, dataClass);
        }
        catch (Throwable t) {
            this.alreadyUsedEntries.clear();
            throw t;
        }
    }

    @NonNull
    private <Model, Data> ModelLoaderFactory<Model, Data> getFactory(@NonNull Entry<?, ?> entry) {
        return entry.factory;
    }

    @NonNull
    private <Model, Data> ModelLoader<Model, Data> build(@NonNull Entry<?, ?> entry) {
        return Preconditions.checkNotNull(entry.factory.build(this));
    }

    @NonNull
    private static <Model, Data> ModelLoader<Model, Data> emptyModelLoader() {
        return EMPTY_MODEL_LOADER;
    }

    private static class EmptyModelLoader
    implements ModelLoader<Object, Object> {
        EmptyModelLoader() {
        }

        @Override
        @Nullable
        public ModelLoader.LoadData<Object> buildLoadData(@NonNull Object o, int width, int height, @NonNull Options options) {
            return null;
        }

        @Override
        public boolean handles(@NonNull Object o) {
            return false;
        }
    }

    static class Factory {
        Factory() {
        }

        @NonNull
        public <Model, Data> MultiModelLoader<Model, Data> build(@NonNull List<ModelLoader<Model, Data>> modelLoaders, @NonNull Pools.Pool<List<Throwable>> throwableListPool) {
            return new MultiModelLoader<Model, Data>(modelLoaders, throwableListPool);
        }
    }

    private static class Entry<Model, Data> {
        private final Class<Model> modelClass;
        final Class<Data> dataClass;
        final ModelLoaderFactory<? extends Model, ? extends Data> factory;

        public Entry(@NonNull Class<Model> modelClass, @NonNull Class<Data> dataClass, @NonNull ModelLoaderFactory<? extends Model, ? extends Data> factory) {
            this.modelClass = modelClass;
            this.dataClass = dataClass;
            this.factory = factory;
        }

        public boolean handles(@NonNull Class<?> modelClass, @NonNull Class<?> dataClass) {
            return this.handles(modelClass) && this.dataClass.isAssignableFrom(dataClass);
        }

        public boolean handles(@NonNull Class<?> modelClass) {
            return this.modelClass.isAssignableFrom(modelClass);
        }
    }
}

