/*
 * Decompiled with CFR 0.152.
 */
package androidx.dynamicanimation.animation;

import android.os.Looper;
import android.util.AndroidRuntimeException;
import android.view.View;
import androidx.annotation.FloatRange;
import androidx.annotation.RestrictTo;
import androidx.core.view.ViewCompat;
import androidx.dynamicanimation.animation.AnimationHandler;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.FloatValueHolder;
import java.util.ArrayList;

public abstract class DynamicAnimation<T extends DynamicAnimation<T>>
implements AnimationHandler.AnimationFrameCallback {
    public static final ViewProperty TRANSLATION_X = new ViewProperty("translationX"){

        @Override
        public void setValue(View view, float value) {
            view.setTranslationX(value);
        }

        @Override
        public float getValue(View view) {
            return view.getTranslationX();
        }
    };
    public static final ViewProperty TRANSLATION_Y = new ViewProperty("translationY"){

        @Override
        public void setValue(View view, float value) {
            view.setTranslationY(value);
        }

        @Override
        public float getValue(View view) {
            return view.getTranslationY();
        }
    };
    public static final ViewProperty TRANSLATION_Z = new ViewProperty("translationZ"){

        @Override
        public void setValue(View view, float value) {
            ViewCompat.setTranslationZ((View)view, (float)value);
        }

        @Override
        public float getValue(View view) {
            return ViewCompat.getTranslationZ((View)view);
        }
    };
    public static final ViewProperty SCALE_X = new ViewProperty("scaleX"){

        @Override
        public void setValue(View view, float value) {
            view.setScaleX(value);
        }

        @Override
        public float getValue(View view) {
            return view.getScaleX();
        }
    };
    public static final ViewProperty SCALE_Y = new ViewProperty("scaleY"){

        @Override
        public void setValue(View view, float value) {
            view.setScaleY(value);
        }

        @Override
        public float getValue(View view) {
            return view.getScaleY();
        }
    };
    public static final ViewProperty ROTATION = new ViewProperty("rotation"){

        @Override
        public void setValue(View view, float value) {
            view.setRotation(value);
        }

        @Override
        public float getValue(View view) {
            return view.getRotation();
        }
    };
    public static final ViewProperty ROTATION_X = new ViewProperty("rotationX"){

        @Override
        public void setValue(View view, float value) {
            view.setRotationX(value);
        }

        @Override
        public float getValue(View view) {
            return view.getRotationX();
        }
    };
    public static final ViewProperty ROTATION_Y = new ViewProperty("rotationY"){

        @Override
        public void setValue(View view, float value) {
            view.setRotationY(value);
        }

        @Override
        public float getValue(View view) {
            return view.getRotationY();
        }
    };
    public static final ViewProperty X = new ViewProperty("x"){

        @Override
        public void setValue(View view, float value) {
            view.setX(value);
        }

        @Override
        public float getValue(View view) {
            return view.getX();
        }
    };
    public static final ViewProperty Y = new ViewProperty("y"){

        @Override
        public void setValue(View view, float value) {
            view.setY(value);
        }

        @Override
        public float getValue(View view) {
            return view.getY();
        }
    };
    public static final ViewProperty Z = new ViewProperty("z"){

        @Override
        public void setValue(View view, float value) {
            ViewCompat.setZ((View)view, (float)value);
        }

        @Override
        public float getValue(View view) {
            return ViewCompat.getZ((View)view);
        }
    };
    public static final ViewProperty ALPHA = new ViewProperty("alpha"){

        @Override
        public void setValue(View view, float value) {
            view.setAlpha(value);
        }

        @Override
        public float getValue(View view) {
            return view.getAlpha();
        }
    };
    public static final ViewProperty SCROLL_X = new ViewProperty("scrollX"){

        @Override
        public void setValue(View view, float value) {
            view.setScrollX((int)value);
        }

        @Override
        public float getValue(View view) {
            return view.getScrollX();
        }
    };
    public static final ViewProperty SCROLL_Y = new ViewProperty("scrollY"){

        @Override
        public void setValue(View view, float value) {
            view.setScrollY((int)value);
        }

        @Override
        public float getValue(View view) {
            return view.getScrollY();
        }
    };
    public static final float MIN_VISIBLE_CHANGE_PIXELS = 1.0f;
    public static final float MIN_VISIBLE_CHANGE_ROTATION_DEGREES = 0.1f;
    public static final float MIN_VISIBLE_CHANGE_ALPHA = 0.00390625f;
    public static final float MIN_VISIBLE_CHANGE_SCALE = 0.002f;
    private static final float UNSET = Float.MAX_VALUE;
    private static final float THRESHOLD_MULTIPLIER = 0.75f;
    float mVelocity = 0.0f;
    float mValue = Float.MAX_VALUE;
    boolean mStartValueIsSet = false;
    final Object mTarget;
    final FloatPropertyCompat mProperty;
    boolean mRunning = false;
    float mMaxValue = Float.MAX_VALUE;
    float mMinValue = -this.mMaxValue;
    private long mLastFrameTime = 0L;
    private float mMinVisibleChange;
    private final ArrayList<OnAnimationEndListener> mEndListeners = new ArrayList();
    private final ArrayList<OnAnimationUpdateListener> mUpdateListeners = new ArrayList();

    DynamicAnimation(final FloatValueHolder floatValueHolder) {
        this.mTarget = null;
        this.mProperty = new FloatPropertyCompat("FloatValueHolder"){

            public float getValue(Object object) {
                return floatValueHolder.getValue();
            }

            public void setValue(Object object, float value) {
                floatValueHolder.setValue(value);
            }
        };
        this.mMinVisibleChange = 1.0f;
    }

    <K> DynamicAnimation(K object, FloatPropertyCompat<K> property) {
        this.mTarget = object;
        this.mProperty = property;
        this.mMinVisibleChange = this.mProperty == ROTATION || this.mProperty == ROTATION_X || this.mProperty == ROTATION_Y ? 0.1f : (this.mProperty == ALPHA ? 0.00390625f : (this.mProperty == SCALE_X || this.mProperty == SCALE_Y ? 0.00390625f : 1.0f));
    }

    public T setStartValue(float startValue) {
        this.mValue = startValue;
        this.mStartValueIsSet = true;
        return (T)this;
    }

    public T setStartVelocity(float startVelocity) {
        this.mVelocity = startVelocity;
        return (T)this;
    }

    public T setMaxValue(float max) {
        this.mMaxValue = max;
        return (T)this;
    }

    public T setMinValue(float min) {
        this.mMinValue = min;
        return (T)this;
    }

    public T addEndListener(OnAnimationEndListener listener) {
        if (!this.mEndListeners.contains(listener)) {
            this.mEndListeners.add(listener);
        }
        return (T)this;
    }

    public void removeEndListener(OnAnimationEndListener listener) {
        DynamicAnimation.removeEntry(this.mEndListeners, listener);
    }

    public T addUpdateListener(OnAnimationUpdateListener listener) {
        if (this.isRunning()) {
            throw new UnsupportedOperationException("Error: Update listeners must be added beforethe animation.");
        }
        if (!this.mUpdateListeners.contains(listener)) {
            this.mUpdateListeners.add(listener);
        }
        return (T)this;
    }

    public void removeUpdateListener(OnAnimationUpdateListener listener) {
        DynamicAnimation.removeEntry(this.mUpdateListeners, listener);
    }

    public T setMinimumVisibleChange(@FloatRange(from=0.0, fromInclusive=false) float minimumVisibleChange) {
        if (minimumVisibleChange <= 0.0f) {
            throw new IllegalArgumentException("Minimum visible change must be positive.");
        }
        this.mMinVisibleChange = minimumVisibleChange;
        this.setValueThreshold(minimumVisibleChange * 0.75f);
        return (T)this;
    }

    public float getMinimumVisibleChange() {
        return this.mMinVisibleChange;
    }

    private static <T> void removeNullEntries(ArrayList<T> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (list.get(i) != null) continue;
            list.remove(i);
        }
    }

    private static <T> void removeEntry(ArrayList<T> list, T entry) {
        int id = list.indexOf(entry);
        if (id >= 0) {
            list.set(id, null);
        }
    }

    public void start() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new AndroidRuntimeException("Animations may only be started on the main thread");
        }
        if (!this.mRunning) {
            this.startAnimationInternal();
        }
    }

    public void cancel() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new AndroidRuntimeException("Animations may only be canceled on the main thread");
        }
        if (this.mRunning) {
            this.endAnimationInternal(true);
        }
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    private void startAnimationInternal() {
        if (!this.mRunning) {
            this.mRunning = true;
            if (!this.mStartValueIsSet) {
                this.mValue = this.getPropertyValue();
            }
            if (this.mValue > this.mMaxValue || this.mValue < this.mMinValue) {
                throw new IllegalArgumentException("Starting value need to be in between min value and max value");
            }
            AnimationHandler.getInstance().addAnimationFrameCallback(this, 0L);
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean doAnimationFrame(long frameTime) {
        if (this.mLastFrameTime == 0L) {
            this.mLastFrameTime = frameTime;
            this.setPropertyValue(this.mValue);
            return false;
        }
        long deltaT = frameTime - this.mLastFrameTime;
        this.mLastFrameTime = frameTime;
        boolean finished = this.updateValueAndVelocity(deltaT);
        this.mValue = Math.min(this.mValue, this.mMaxValue);
        this.mValue = Math.max(this.mValue, this.mMinValue);
        this.setPropertyValue(this.mValue);
        if (finished) {
            this.endAnimationInternal(false);
        }
        return finished;
    }

    abstract boolean updateValueAndVelocity(long var1);

    private void endAnimationInternal(boolean canceled) {
        this.mRunning = false;
        AnimationHandler.getInstance().removeCallback(this);
        this.mLastFrameTime = 0L;
        this.mStartValueIsSet = false;
        for (int i = 0; i < this.mEndListeners.size(); ++i) {
            if (this.mEndListeners.get(i) == null) continue;
            this.mEndListeners.get(i).onAnimationEnd(this, canceled, this.mValue, this.mVelocity);
        }
        DynamicAnimation.removeNullEntries(this.mEndListeners);
    }

    void setPropertyValue(float value) {
        this.mProperty.setValue(this.mTarget, value);
        for (int i = 0; i < this.mUpdateListeners.size(); ++i) {
            if (this.mUpdateListeners.get(i) == null) continue;
            this.mUpdateListeners.get(i).onAnimationUpdate(this, this.mValue, this.mVelocity);
        }
        DynamicAnimation.removeNullEntries(this.mUpdateListeners);
    }

    float getValueThreshold() {
        return this.mMinVisibleChange * 0.75f;
    }

    private float getPropertyValue() {
        return this.mProperty.getValue(this.mTarget);
    }

    abstract float getAcceleration(float var1, float var2);

    abstract boolean isAtEquilibrium(float var1, float var2);

    abstract void setValueThreshold(float var1);

    public static interface OnAnimationUpdateListener {
        public void onAnimationUpdate(DynamicAnimation var1, float var2, float var3);
    }

    public static interface OnAnimationEndListener {
        public void onAnimationEnd(DynamicAnimation var1, boolean var2, float var3, float var4);
    }

    static class MassState {
        float mValue;
        float mVelocity;

        MassState() {
        }
    }

    public static abstract class ViewProperty
    extends FloatPropertyCompat<View> {
        private ViewProperty(String name) {
            super(name);
        }
    }
}

