/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.Window;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;

final class ThemeUtils {
    private ThemeUtils() {
    }

    static void applyThemeOverlay(@NonNull Context context, @StyleRes int theme) {
        Resources.Theme windowDecorViewTheme;
        context.getTheme().applyStyle(theme, true);
        if (context instanceof Activity && (windowDecorViewTheme = ThemeUtils.getWindowDecorViewTheme((Activity)context)) != null) {
            windowDecorViewTheme.applyStyle(theme, true);
        }
    }

    @Nullable
    private static Resources.Theme getWindowDecorViewTheme(@NonNull Activity activity) {
        Context context;
        View decorView;
        Window window = activity.getWindow();
        if (window != null && (decorView = window.peekDecorView()) != null && (context = decorView.getContext()) != null) {
            return context.getTheme();
        }
        return null;
    }
}

