/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import android.os.Process;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.EngineResource;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.util.Preconditions;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

final class ActiveResources {
    private final boolean isActiveResourceRetentionAllowed;
    private final Executor monitorClearedResourcesExecutor;
    @VisibleForTesting
    final Map<Key, ResourceWeakReference> activeEngineResources = new HashMap<Key, ResourceWeakReference>();
    private final ReferenceQueue<EngineResource<?>> resourceReferenceQueue = new ReferenceQueue();
    private EngineResource.ResourceListener listener;
    private volatile boolean isShutdown;
    @Nullable
    private volatile DequeuedResourceCallback cb;

    ActiveResources(boolean isActiveResourceRetentionAllowed) {
        this(isActiveResourceRetentionAllowed, Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(final @NonNull Runnable r) {
                return new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Process.setThreadPriority((int)10);
                        r.run();
                    }
                }, "glide-active-resources");
            }
        }));
    }

    @VisibleForTesting
    ActiveResources(boolean isActiveResourceRetentionAllowed, Executor monitorClearedResourcesExecutor) {
        this.isActiveResourceRetentionAllowed = isActiveResourceRetentionAllowed;
        this.monitorClearedResourcesExecutor = monitorClearedResourcesExecutor;
        monitorClearedResourcesExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ActiveResources.this.cleanReferenceQueue();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setListener(EngineResource.ResourceListener listener) {
        EngineResource.ResourceListener resourceListener = listener;
        synchronized (resourceListener) {
            ActiveResources activeResources = this;
            synchronized (activeResources) {
                this.listener = listener;
            }
        }
    }

    synchronized void activate(Key key, EngineResource<?> resource) {
        ResourceWeakReference toPut = new ResourceWeakReference(key, resource, this.resourceReferenceQueue, this.isActiveResourceRetentionAllowed);
        ResourceWeakReference removed = this.activeEngineResources.put(key, toPut);
        if (removed != null) {
            removed.reset();
        }
    }

    synchronized void deactivate(Key key) {
        ResourceWeakReference removed = this.activeEngineResources.remove(key);
        if (removed != null) {
            removed.reset();
        }
    }

    @Nullable
    synchronized EngineResource<?> get(Key key) {
        ResourceWeakReference activeRef = this.activeEngineResources.get(key);
        if (activeRef == null) {
            return null;
        }
        EngineResource active = (EngineResource)activeRef.get();
        if (active == null) {
            this.cleanupActiveReference(activeRef);
        }
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupActiveReference(@NonNull ResourceWeakReference ref) {
        ActiveResources activeResources = this;
        synchronized (activeResources) {
            this.activeEngineResources.remove(ref.key);
            if (!ref.isCacheable || ref.resource == null) {
                return;
            }
        }
        EngineResource newResource = new EngineResource(ref.resource, true, false, ref.key, this.listener);
        this.listener.onResourceReleased(ref.key, newResource);
    }

    void cleanReferenceQueue() {
        while (!this.isShutdown) {
            try {
                ResourceWeakReference ref = (ResourceWeakReference)this.resourceReferenceQueue.remove();
                this.cleanupActiveReference(ref);
                DequeuedResourceCallback current = this.cb;
                if (current == null) continue;
                current.onResourceDequeued();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @VisibleForTesting
    void setDequeuedResourceCallback(DequeuedResourceCallback cb) {
        this.cb = cb;
    }

    @VisibleForTesting
    void shutdown() {
        this.isShutdown = true;
        if (this.monitorClearedResourcesExecutor instanceof ExecutorService) {
            ExecutorService service = (ExecutorService)this.monitorClearedResourcesExecutor;
            com.bumptech.glide.util.Executors.shutdownAndAwaitTermination(service);
        }
    }

    @VisibleForTesting
    static final class ResourceWeakReference
    extends WeakReference<EngineResource<?>> {
        final Key key;
        final boolean isCacheable;
        @Nullable
        Resource<?> resource;

        ResourceWeakReference(@NonNull Key key, @NonNull EngineResource<?> referent, @NonNull ReferenceQueue<? super EngineResource<?>> queue, boolean isActiveResourceRetentionAllowed) {
            super(referent, queue);
            this.key = Preconditions.checkNotNull(key);
            this.resource = referent.isMemoryCacheable() && isActiveResourceRetentionAllowed ? Preconditions.checkNotNull(referent.getResource()) : null;
            this.isCacheable = referent.isMemoryCacheable();
        }

        void reset() {
            this.resource = null;
            this.clear();
        }
    }

    @VisibleForTesting
    static interface DequeuedResourceCallback {
        public void onResourceDequeued();
    }
}

