/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import com.bumptech.glide.util.Util;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public final class HardwareConfigState {
    private static final String TAG = "HardwareConfig";
    public static final boolean BLOCK_HARDWARE_BITMAPS_WHEN_GL_CONTEXT_MIGHT_NOT_BE_INITIALIZED = Build.VERSION.SDK_INT < 29;
    public static final boolean HARDWARE_BITMAPS_SUPPORTED = Build.VERSION.SDK_INT >= 26;
    @VisibleForTesting
    static final int MIN_HARDWARE_DIMENSION_O = 128;
    private static final int MIN_HARDWARE_DIMENSION_P = 0;
    private static final File FD_SIZE_LIST = new File("/proc/self/fd");
    private static final int MINIMUM_DECODES_BETWEEN_FD_CHECKS = 50;
    private static final int MAXIMUM_FDS_FOR_HARDWARE_CONFIGS_O = 700;
    private static final int MAXIMUM_FDS_FOR_HARDWARE_CONFIGS_P = 20000;
    public static final int NO_MAX_FD_COUNT = -1;
    private static volatile HardwareConfigState instance;
    private static volatile int manualOverrideMaxFdCount;
    private final boolean isHardwareConfigAllowedByDeviceModel;
    private final int sdkBasedMaxFdCount;
    private final int minHardwareDimension;
    @GuardedBy(value="this")
    private int decodesSinceLastFdCheck;
    @GuardedBy(value="this")
    private boolean isFdSizeBelowHardwareLimit = true;
    private final AtomicBoolean isHardwareConfigAllowedByAppState = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HardwareConfigState getInstance() {
        if (instance != null) return instance;
        Class<HardwareConfigState> clazz = HardwareConfigState.class;
        synchronized (HardwareConfigState.class) {
            if (instance != null) return instance;
            instance = new HardwareConfigState();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @VisibleForTesting
    HardwareConfigState() {
        this.isHardwareConfigAllowedByDeviceModel = HardwareConfigState.isHardwareConfigAllowedByDeviceModel();
        if (Build.VERSION.SDK_INT >= 28) {
            this.sdkBasedMaxFdCount = 20000;
            this.minHardwareDimension = 0;
        } else {
            this.sdkBasedMaxFdCount = 700;
            this.minHardwareDimension = 128;
        }
    }

    public boolean areHardwareBitmapsBlocked() {
        Util.assertMainThread();
        return !this.isHardwareConfigAllowedByAppState.get();
    }

    public void blockHardwareBitmaps() {
        Util.assertMainThread();
        this.isHardwareConfigAllowedByAppState.set(false);
    }

    public void unblockHardwareBitmaps() {
        Util.assertMainThread();
        this.isHardwareConfigAllowedByAppState.set(true);
    }

    public boolean isHardwareConfigAllowed(int targetWidth, int targetHeight, boolean isHardwareConfigAllowed, boolean isExifOrientationRequired) {
        if (!isHardwareConfigAllowed) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Hardware config disallowed by caller");
            }
            return false;
        }
        if (!this.isHardwareConfigAllowedByDeviceModel) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Hardware config disallowed by device model");
            }
            return false;
        }
        if (!HARDWARE_BITMAPS_SUPPORTED) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Hardware config disallowed by sdk");
            }
            return false;
        }
        if (this.areHardwareBitmapsBlockedByAppState()) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Hardware config disallowed by app state");
            }
            return false;
        }
        if (isExifOrientationRequired) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Hardware config disallowed because exif orientation is required");
            }
            return false;
        }
        if (targetWidth < this.minHardwareDimension) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Hardware config disallowed because width is too small");
            }
            return false;
        }
        if (targetHeight < this.minHardwareDimension) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Hardware config disallowed because height is too small");
            }
            return false;
        }
        if (!this.isFdSizeBelowHardwareLimit()) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"Hardware config disallowed because there are insufficient FDs");
            }
            return false;
        }
        return true;
    }

    private boolean areHardwareBitmapsBlockedByAppState() {
        return BLOCK_HARDWARE_BITMAPS_WHEN_GL_CONTEXT_MIGHT_NOT_BE_INITIALIZED && !this.isHardwareConfigAllowedByAppState.get();
    }

    @TargetApi(value=26)
    boolean setHardwareConfigIfAllowed(int targetWidth, int targetHeight, BitmapFactory.Options optionsWithScaling, boolean isHardwareConfigAllowed, boolean isExifOrientationRequired) {
        boolean result = this.isHardwareConfigAllowed(targetWidth, targetHeight, isHardwareConfigAllowed, isExifOrientationRequired);
        if (result) {
            optionsWithScaling.inPreferredConfig = Bitmap.Config.HARDWARE;
            optionsWithScaling.inMutable = false;
        }
        return result;
    }

    private static boolean isHardwareConfigAllowedByDeviceModel() {
        return !HardwareConfigState.isHardwareConfigDisallowedByB112551574() && !HardwareConfigState.isHardwareConfigDisallowedByB147430447();
    }

    private static boolean isHardwareConfigDisallowedByB147430447() {
        if (Build.VERSION.SDK_INT != 27) {
            return false;
        }
        return Arrays.asList("LG-M250", "LG-M320", "LG-Q710AL", "LG-Q710PL", "LGM-K121K", "LGM-K121L", "LGM-K121S", "LGM-X320K", "LGM-X320L", "LGM-X320S", "LGM-X401L", "LGM-X401S", "LM-Q610.FG", "LM-Q610.FGN", "LM-Q617.FG", "LM-Q617.FGN", "LM-Q710.FG", "LM-Q710.FGN", "LM-X220PM", "LM-X220QMA", "LM-X410PM").contains(Build.MODEL);
    }

    private static boolean isHardwareConfigDisallowedByB112551574() {
        if (Build.VERSION.SDK_INT != 26) {
            return false;
        }
        for (String prefixOrModelName : Arrays.asList("SC-04J", "SM-N935", "SM-J720", "SM-G570F", "SM-G570M", "SM-G960", "SM-G965", "SM-G935", "SM-G930", "SM-A520", "SM-A720F", "moto e5", "moto e5 play", "moto e5 plus", "moto e5 cruise", "moto g(6) forge", "moto g(6) play")) {
            if (!Build.MODEL.startsWith(prefixOrModelName)) continue;
            return true;
        }
        return false;
    }

    private int getMaxFdCount() {
        return manualOverrideMaxFdCount != -1 ? manualOverrideMaxFdCount : this.sdkBasedMaxFdCount;
    }

    private synchronized boolean isFdSizeBelowHardwareLimit() {
        if (++this.decodesSinceLastFdCheck >= 50) {
            long maxFdCount;
            this.decodesSinceLastFdCheck = 0;
            int currentFds = FD_SIZE_LIST.list().length;
            boolean bl = this.isFdSizeBelowHardwareLimit = (long)currentFds < (maxFdCount = (long)this.getMaxFdCount());
            if (!this.isFdSizeBelowHardwareLimit && Log.isLoggable((String)"Downsampler", (int)5)) {
                Log.w((String)"Downsampler", (String)("Excluding HARDWARE bitmap config because we're over the file descriptor limit, file descriptors " + currentFds + ", limit " + maxFdCount));
            }
        }
        return this.isFdSizeBelowHardwareLimit;
    }

    static {
        manualOverrideMaxFdCount = -1;
    }
}

