/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.utils;

import android.os.Build;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.motion.utils.CustomSupport;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintAttribute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ViewSpline
extends SplineSet {
    private static final String TAG = "ViewSpline";

    public static ViewSpline makeCustomSpline(String str, SparseArray<ConstraintAttribute> attrList) {
        return new CustomSet(str, attrList);
    }

    public static ViewSpline makeSpline(String str) {
        switch (str) {
            case "alpha": {
                return new AlphaSet();
            }
            case "elevation": {
                return new ElevationSet();
            }
            case "rotation": {
                return new RotationSet();
            }
            case "rotationX": {
                return new RotationXset();
            }
            case "rotationY": {
                return new RotationYset();
            }
            case "transformPivotX": {
                return new PivotXset();
            }
            case "transformPivotY": {
                return new PivotYset();
            }
            case "transitionPathRotate": {
                return new PathRotate();
            }
            case "scaleX": {
                return new ScaleXset();
            }
            case "scaleY": {
                return new ScaleYset();
            }
            case "waveOffset": {
                return new AlphaSet();
            }
            case "waveVariesBy": {
                return new AlphaSet();
            }
            case "translationX": {
                return new TranslationXset();
            }
            case "translationY": {
                return new TranslationYset();
            }
            case "translationZ": {
                return new TranslationZset();
            }
            case "progress": {
                return new ProgressSet();
            }
        }
        return null;
    }

    public abstract void setProperty(View var1, float var2);

    static class ProgressSet
    extends ViewSpline {
        boolean mNoMethod = false;

        ProgressSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            if (view instanceof MotionLayout) {
                ((MotionLayout)view).setProgress(this.get(t));
            } else {
                if (this.mNoMethod) {
                    return;
                }
                Method method = null;
                try {
                    method = view.getClass().getMethod("setProgress", Float.TYPE);
                }
                catch (NoSuchMethodException e) {
                    this.mNoMethod = true;
                }
                if (method != null) {
                    try {
                        method.invoke((Object)view, Float.valueOf(this.get(t)));
                    }
                    catch (IllegalAccessException e) {
                        Log.e((String)ViewSpline.TAG, (String)"unable to setProgress", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        Log.e((String)ViewSpline.TAG, (String)"unable to setProgress", (Throwable)e);
                    }
                }
            }
        }
    }

    public static class CustomSet
    extends ViewSpline {
        String mAttributeName;
        SparseArray<ConstraintAttribute> mConstraintAttributeList;
        float[] mTempValues;

        public CustomSet(String attribute, SparseArray<ConstraintAttribute> attrList) {
            this.mAttributeName = attribute.split(",")[1];
            this.mConstraintAttributeList = attrList;
        }

        public void setup(int curveType) {
            int size = this.mConstraintAttributeList.size();
            int dimensionality = ((ConstraintAttribute)this.mConstraintAttributeList.valueAt(0)).numberOfInterpolatedValues();
            double[] time = new double[size];
            this.mTempValues = new float[dimensionality];
            double[][] values = new double[size][dimensionality];
            for (int i = 0; i < size; ++i) {
                int key = this.mConstraintAttributeList.keyAt(i);
                ConstraintAttribute ca = (ConstraintAttribute)this.mConstraintAttributeList.valueAt(i);
                time[i] = (double)key * 0.01;
                ca.getValuesToInterpolate(this.mTempValues);
                for (int k = 0; k < this.mTempValues.length; ++k) {
                    values[i][k] = this.mTempValues[k];
                }
            }
            this.mCurveFit = CurveFit.get((int)curveType, (double[])time, (double[][])values);
        }

        public void setPoint(int position, float value) {
            throw new RuntimeException("don't call for custom attribute call setPoint(pos, ConstraintAttribute)");
        }

        public void setPoint(int position, ConstraintAttribute value) {
            this.mConstraintAttributeList.append(position, (Object)value);
        }

        @Override
        public void setProperty(View view, float t) {
            this.mCurveFit.getPos((double)t, this.mTempValues);
            CustomSupport.setInterpolatedValue((ConstraintAttribute)this.mConstraintAttributeList.valueAt(0), view, this.mTempValues);
        }
    }

    static class TranslationZset
    extends ViewSpline {
        TranslationZset() {
        }

        @Override
        public void setProperty(View view, float t) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setTranslationZ(this.get(t));
            }
        }
    }

    static class TranslationYset
    extends ViewSpline {
        TranslationYset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setTranslationY(this.get(t));
        }
    }

    static class TranslationXset
    extends ViewSpline {
        TranslationXset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setTranslationX(this.get(t));
        }
    }

    static class ScaleYset
    extends ViewSpline {
        ScaleYset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setScaleY(this.get(t));
        }
    }

    static class ScaleXset
    extends ViewSpline {
        ScaleXset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setScaleX(this.get(t));
        }
    }

    public static class PathRotate
    extends ViewSpline {
        @Override
        public void setProperty(View view, float t) {
        }

        public void setPathRotate(View view, float t, double dx, double dy) {
            view.setRotation(this.get(t) + (float)Math.toDegrees(Math.atan2(dy, dx)));
        }
    }

    static class PivotYset
    extends ViewSpline {
        PivotYset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setPivotY(this.get(t));
        }
    }

    static class PivotXset
    extends ViewSpline {
        PivotXset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setPivotX(this.get(t));
        }
    }

    static class RotationYset
    extends ViewSpline {
        RotationYset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setRotationY(this.get(t));
        }
    }

    static class RotationXset
    extends ViewSpline {
        RotationXset() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setRotationX(this.get(t));
        }
    }

    static class RotationSet
    extends ViewSpline {
        RotationSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setRotation(this.get(t));
        }
    }

    static class AlphaSet
    extends ViewSpline {
        AlphaSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            view.setAlpha(this.get(t));
        }
    }

    static class ElevationSet
    extends ViewSpline {
        ElevationSet() {
        }

        @Override
        public void setProperty(View view, float t) {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setElevation(this.get(t));
            }
        }
    }
}

