/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.WorkerThread;
import androidx.core.os.TraceCompat;
import androidx.emoji2.text.ConcurrencyHelpers;
import androidx.emoji2.text.DefaultEmojiCompatConfig;
import androidx.emoji2.text.EmojiCompat;
import androidx.emoji2.text.FontRequestEmojiCompatConfig;
import androidx.emoji2.text.MetadataRepo;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleInitializer;
import androidx.startup.AppInitializer;
import androidx.startup.Initializer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;

public class EmojiCompatInitializer
implements Initializer<Boolean> {
    private static final long STARTUP_THREAD_CREATION_DELAY_MS = 500L;
    private static final String S_INITIALIZER_THREAD_NAME = "EmojiCompatInitializer";

    @NonNull
    public Boolean create(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 19) {
            EmojiCompat.init(new BackgroundDefaultConfig(context));
            this.delayUntilFirstResume(context);
            return true;
        }
        return false;
    }

    @RequiresApi(value=19)
    void delayUntilFirstResume(@NonNull Context context) {
        AppInitializer appInitializer = AppInitializer.getInstance((Context)context);
        LifecycleOwner lifecycleOwner = (LifecycleOwner)appInitializer.initializeComponent(ProcessLifecycleInitializer.class);
        final Lifecycle lifecycle = lifecycleOwner.getLifecycle();
        lifecycle.addObserver((LifecycleObserver)new DefaultLifecycleObserver(){

            public void onResume(@NonNull LifecycleOwner owner) {
                EmojiCompatInitializer.this.loadEmojiCompatAfterDelay();
                lifecycle.removeObserver((LifecycleObserver)this);
            }
        });
    }

    @RequiresApi(value=19)
    void loadEmojiCompatAfterDelay() {
        Handler mainHandler = ConcurrencyHelpers.mainHandlerAsync();
        mainHandler.postDelayed((Runnable)new LoadEmojiCompatRunnable(), 500L);
    }

    @NonNull
    public List<Class<? extends Initializer<?>>> dependencies() {
        return Collections.singletonList(ProcessLifecycleInitializer.class);
    }

    @RequiresApi(value=19)
    static class BackgroundDefaultLoader
    implements EmojiCompat.MetadataRepoLoader {
        private final Context mContext;

        BackgroundDefaultLoader(Context context) {
            this.mContext = context.getApplicationContext();
        }

        @Override
        public void load(@NonNull EmojiCompat.MetadataRepoLoaderCallback loaderCallback) {
            ThreadPoolExecutor executor = ConcurrencyHelpers.createBackgroundPriorityExecutor(EmojiCompatInitializer.S_INITIALIZER_THREAD_NAME);
            executor.execute(() -> this.doLoad(loaderCallback, executor));
        }

        @WorkerThread
        void doLoad(final @NonNull EmojiCompat.MetadataRepoLoaderCallback loaderCallback, final @NonNull ThreadPoolExecutor executor) {
            try {
                FontRequestEmojiCompatConfig config = DefaultEmojiCompatConfig.create(this.mContext);
                if (config == null) {
                    throw new RuntimeException("EmojiCompat font provider not available on this device.");
                }
                config.setLoadingExecutor(executor);
                config.getMetadataRepoLoader().load(new EmojiCompat.MetadataRepoLoaderCallback(){

                    @Override
                    public void onLoaded(@NonNull MetadataRepo metadataRepo) {
                        try {
                            loaderCallback.onLoaded(metadataRepo);
                        }
                        finally {
                            executor.shutdown();
                        }
                    }

                    @Override
                    public void onFailed(@Nullable Throwable throwable) {
                        try {
                            loaderCallback.onFailed(throwable);
                        }
                        finally {
                            executor.shutdown();
                        }
                    }
                });
            }
            catch (Throwable t) {
                loaderCallback.onFailed(t);
                executor.shutdown();
            }
        }
    }

    @RequiresApi(value=19)
    static class BackgroundDefaultConfig
    extends EmojiCompat.Config {
        protected BackgroundDefaultConfig(Context context) {
            super(new BackgroundDefaultLoader(context));
            this.setMetadataLoadStrategy(1);
        }
    }

    static class LoadEmojiCompatRunnable
    implements Runnable {
        LoadEmojiCompatRunnable() {
        }

        @Override
        public void run() {
            try {
                TraceCompat.beginSection((String)"EmojiCompat.EmojiCompatInitializer.run");
                if (EmojiCompat.isConfigured()) {
                    EmojiCompat.get().load();
                }
            }
            finally {
                TraceCompat.endSection();
            }
        }
    }
}

