/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.google.android.material.R;
import com.google.android.material.resources.MaterialAttributes;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class MaterialTextView
extends AppCompatTextView {
    public MaterialTextView(@NonNull Context context) {
        this(context, null);
    }

    public MaterialTextView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public MaterialTextView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public MaterialTextView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, defStyleRes), attrs, defStyleAttr);
        int resId;
        Resources.Theme theme;
        context = this.getContext();
        if (MaterialTextView.canApplyTextAppearanceLineHeight(context) && !MaterialTextView.viewAttrsHasLineHeight(context, theme = context.getTheme(), attrs, defStyleAttr, defStyleRes) && (resId = MaterialTextView.findViewAppearanceResourceId(theme, attrs, defStyleAttr, defStyleRes)) != -1) {
            this.applyLineHeightFromViewAppearance(theme, resId);
        }
    }

    public void setTextAppearance(@NonNull Context context, int resId) {
        super.setTextAppearance(context, resId);
        if (MaterialTextView.canApplyTextAppearanceLineHeight(context)) {
            this.applyLineHeightFromViewAppearance(context.getTheme(), resId);
        }
    }

    private void applyLineHeightFromViewAppearance(@NonNull Resources.Theme theme, int resId) {
        TypedArray attributes = theme.obtainStyledAttributes(resId, R.styleable.MaterialTextAppearance);
        int lineHeight = MaterialTextView.readFirstAvailableDimension(this.getContext(), attributes, R.styleable.MaterialTextAppearance_android_lineHeight, R.styleable.MaterialTextAppearance_lineHeight);
        attributes.recycle();
        if (lineHeight >= 0) {
            this.setLineHeight(lineHeight);
        }
    }

    private static boolean canApplyTextAppearanceLineHeight(Context context) {
        return MaterialAttributes.resolveBoolean(context, R.attr.textAppearanceLineHeightEnabled, true);
    }

    private static int readFirstAvailableDimension(@NonNull Context context, @NonNull TypedArray attributes, int ... indices) {
        int lineHeight = -1;
        for (int index = 0; index < indices.length && lineHeight < 0; ++index) {
            lineHeight = MaterialResources.getDimensionPixelSize(context, attributes, indices[index], -1);
        }
        return lineHeight;
    }

    private static boolean viewAttrsHasLineHeight(@NonNull Context context, @NonNull Resources.Theme theme, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray attributes = theme.obtainStyledAttributes(attrs, R.styleable.MaterialTextView, defStyleAttr, defStyleRes);
        int lineHeight = MaterialTextView.readFirstAvailableDimension(context, attributes, R.styleable.MaterialTextView_android_lineHeight, R.styleable.MaterialTextView_lineHeight);
        attributes.recycle();
        return lineHeight != -1;
    }

    private static int findViewAppearanceResourceId(@NonNull Resources.Theme theme, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray attributes = theme.obtainStyledAttributes(attrs, R.styleable.MaterialTextView, defStyleAttr, defStyleRes);
        int appearanceAttrId = attributes.getResourceId(R.styleable.MaterialTextView_android_textAppearance, -1);
        attributes.recycle();
        return appearanceAttrId;
    }
}

