/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.tabs;

import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.tabs.TabIndicatorInterpolator;
import com.google.android.material.tabs.TabLayout;

class FadeTabIndicatorInterpolator
extends TabIndicatorInterpolator {
    private static final float FADE_THRESHOLD = 0.5f;

    FadeTabIndicatorInterpolator() {
    }

    @Override
    void updateIndicatorForOffset(TabLayout tabLayout, View startTitle, View endTitle, float offset, @NonNull Drawable indicator) {
        View tab = offset < 0.5f ? startTitle : endTitle;
        RectF bounds = FadeTabIndicatorInterpolator.calculateIndicatorWidthForTab(tabLayout, tab);
        float alpha = offset < 0.5f ? AnimationUtils.lerp(1.0f, 0.0f, 0.0f, 0.5f, offset) : AnimationUtils.lerp(0.0f, 1.0f, 0.5f, 1.0f, offset);
        indicator.setBounds((int)bounds.left, indicator.getBounds().top, (int)bounds.right, indicator.getBounds().bottom);
        indicator.setAlpha((int)(alpha * 255.0f));
    }
}

