/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.android;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.CleartextKeysetHandle;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetManager;
import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.KeysetWriter;
import com.google.crypto.tink.integration.android.AndroidKeystoreKmsClient;
import com.google.crypto.tink.integration.android.SharedPrefKeysetReader;
import com.google.crypto.tink.integration.android.SharedPrefKeysetWriter;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.ProviderException;
import javax.annotation.concurrent.GuardedBy;

public final class AndroidKeysetManager {
    private static final String TAG = AndroidKeysetManager.class.getSimpleName();
    private final KeysetWriter writer;
    private final Aead masterKey;
    @GuardedBy(value="this")
    private KeysetManager keysetManager;

    private AndroidKeysetManager(Builder builder) throws GeneralSecurityException, IOException {
        this.writer = builder.writer;
        this.masterKey = builder.masterKey;
        this.keysetManager = builder.keysetManager;
    }

    public synchronized KeysetHandle getKeysetHandle() throws GeneralSecurityException {
        return this.keysetManager.getKeysetHandle();
    }

    @Deprecated
    public synchronized AndroidKeysetManager rotate(com.google.crypto.tink.proto.KeyTemplate keyTemplate) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.rotate(keyTemplate);
        this.write(this.keysetManager);
        return this;
    }

    @Deprecated
    @GuardedBy(value="this")
    public synchronized AndroidKeysetManager add(com.google.crypto.tink.proto.KeyTemplate keyTemplate) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.add(keyTemplate);
        this.write(this.keysetManager);
        return this;
    }

    @GuardedBy(value="this")
    public synchronized AndroidKeysetManager add(KeyTemplate keyTemplate) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.add(keyTemplate);
        this.write(this.keysetManager);
        return this;
    }

    public synchronized AndroidKeysetManager setPrimary(int keyId) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.setPrimary(keyId);
        this.write(this.keysetManager);
        return this;
    }

    @Deprecated
    public synchronized AndroidKeysetManager promote(int keyId) throws GeneralSecurityException {
        return this.setPrimary(keyId);
    }

    public synchronized AndroidKeysetManager enable(int keyId) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.enable(keyId);
        this.write(this.keysetManager);
        return this;
    }

    public synchronized AndroidKeysetManager disable(int keyId) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.disable(keyId);
        this.write(this.keysetManager);
        return this;
    }

    public synchronized AndroidKeysetManager delete(int keyId) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.delete(keyId);
        this.write(this.keysetManager);
        return this;
    }

    public synchronized AndroidKeysetManager destroy(int keyId) throws GeneralSecurityException {
        this.keysetManager = this.keysetManager.destroy(keyId);
        this.write(this.keysetManager);
        return this;
    }

    public synchronized boolean isUsingKeystore() {
        return this.shouldUseKeystore();
    }

    private void write(KeysetManager manager) throws GeneralSecurityException {
        try {
            if (this.shouldUseKeystore()) {
                manager.getKeysetHandle().write(this.writer, this.masterKey);
            } else {
                CleartextKeysetHandle.write(manager.getKeysetHandle(), this.writer);
            }
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    private boolean shouldUseKeystore() {
        return this.masterKey != null && AndroidKeysetManager.isAtLeastM();
    }

    private static KeyTemplate.OutputPrefixType fromProto(OutputPrefixType outputPrefixType) {
        switch (outputPrefixType) {
            case TINK: {
                return KeyTemplate.OutputPrefixType.TINK;
            }
            case LEGACY: {
                return KeyTemplate.OutputPrefixType.LEGACY;
            }
            case RAW: {
                return KeyTemplate.OutputPrefixType.RAW;
            }
            case CRUNCHY: {
                return KeyTemplate.OutputPrefixType.CRUNCHY;
            }
        }
        throw new IllegalArgumentException("Unknown output prefix type");
    }

    private static boolean isAtLeastM() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static final class Builder {
        private KeysetReader reader = null;
        private KeysetWriter writer = null;
        private String masterKeyUri = null;
        private Aead masterKey = null;
        private boolean useKeystore = true;
        private KeyTemplate keyTemplate = null;
        private KeyStore keyStore = null;
        @GuardedBy(value="this")
        private KeysetManager keysetManager;

        public Builder withSharedPref(Context context, String keysetName, String prefFileName) throws IOException {
            if (context == null) {
                throw new IllegalArgumentException("need an Android context");
            }
            if (keysetName == null) {
                throw new IllegalArgumentException("need a keyset name");
            }
            this.reader = new SharedPrefKeysetReader(context, keysetName, prefFileName);
            this.writer = new SharedPrefKeysetWriter(context, keysetName, prefFileName);
            return this;
        }

        public Builder withMasterKeyUri(String val) {
            if (!val.startsWith("android-keystore://")) {
                throw new IllegalArgumentException("key URI must start with android-keystore://");
            }
            if (!this.useKeystore) {
                throw new IllegalArgumentException("cannot call withMasterKeyUri() after calling doNotUseKeystore()");
            }
            this.masterKeyUri = val;
            return this;
        }

        @Deprecated
        public Builder withKeyTemplate(com.google.crypto.tink.proto.KeyTemplate val) {
            this.keyTemplate = KeyTemplate.create(val.getTypeUrl(), val.getValue().toByteArray(), AndroidKeysetManager.fromProto(val.getOutputPrefixType()));
            return this;
        }

        public Builder withKeyTemplate(KeyTemplate val) {
            this.keyTemplate = val;
            return this;
        }

        @Deprecated
        public Builder doNotUseKeystore() {
            this.masterKeyUri = null;
            this.useKeystore = false;
            return this;
        }

        Builder withKeyStore(KeyStore val) {
            this.keyStore = val;
            return this;
        }

        public synchronized AndroidKeysetManager build() throws GeneralSecurityException, IOException {
            if (this.masterKeyUri != null) {
                this.masterKey = this.readOrGenerateNewMasterKey();
            }
            this.keysetManager = this.readOrGenerateNewKeyset();
            return new AndroidKeysetManager(this);
        }

        private Aead readOrGenerateNewMasterKey() throws GeneralSecurityException {
            if (!AndroidKeysetManager.isAtLeastM()) {
                Log.w((String)TAG, (String)"Android Keystore requires at least Android M");
                return null;
            }
            AndroidKeystoreKmsClient client = this.keyStore != null ? new AndroidKeystoreKmsClient.Builder().setKeyStore(this.keyStore).build() : new AndroidKeystoreKmsClient();
            boolean existed = client.hasKey(this.masterKeyUri);
            if (!existed) {
                try {
                    AndroidKeystoreKmsClient.generateNewAeadKey(this.masterKeyUri);
                }
                catch (GeneralSecurityException | ProviderException ex) {
                    Log.w((String)TAG, (String)"cannot use Android Keystore, it'll be disabled", (Throwable)ex);
                    return null;
                }
            }
            try {
                return client.getAead(this.masterKeyUri);
            }
            catch (GeneralSecurityException | ProviderException ex) {
                if (existed) {
                    throw new KeyStoreException(String.format("the master key %s exists but is unusable", this.masterKeyUri), ex);
                }
                Log.w((String)TAG, (String)"cannot use Android Keystore, it'll be disabled", (Throwable)ex);
                return null;
            }
        }

        private KeysetManager readOrGenerateNewKeyset() throws GeneralSecurityException, IOException {
            try {
                return this.read();
            }
            catch (FileNotFoundException ex) {
                Log.i((String)TAG, (String)"keyset not found, will generate a new one", (Throwable)ex);
                if (this.keyTemplate != null) {
                    KeysetManager manager = KeysetManager.withEmptyKeyset().add(this.keyTemplate);
                    int keyId = manager.getKeysetHandle().getKeysetInfo().getKeyInfo(0).getKeyId();
                    manager = manager.setPrimary(keyId);
                    if (this.masterKey != null) {
                        manager.getKeysetHandle().write(this.writer, this.masterKey);
                    } else {
                        CleartextKeysetHandle.write(manager.getKeysetHandle(), this.writer);
                    }
                    return manager;
                }
                throw new GeneralSecurityException("cannot read or generate keyset");
            }
        }

        private KeysetManager read() throws GeneralSecurityException, IOException {
            if (this.masterKey != null) {
                try {
                    return KeysetManager.withKeysetHandle(KeysetHandle.read(this.reader, this.masterKey));
                }
                catch (InvalidProtocolBufferException | GeneralSecurityException ex) {
                    Log.w((String)TAG, (String)"cannot decrypt keyset: ", (Throwable)ex);
                }
            }
            return KeysetManager.withKeysetHandle(CleartextKeysetHandle.read(this.reader));
        }
    }
}

