/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import com.google.android.material.color.Cam16;
import com.google.android.material.color.ColorUtils;
import com.google.android.material.color.Hct;
import com.google.android.material.color.MathUtils;

final class Blend {
    private static final float HARMONIZE_MAX_DEGREES = 15.0f;
    private static final float HARMONIZE_PERCENTAGE = 0.5f;

    private Blend() {
    }

    public static int harmonize(int designColor, int sourceColor) {
        Hct fromHct = Hct.fromInt(designColor);
        Hct toHct = Hct.fromInt(sourceColor);
        float differenceDegrees = MathUtils.differenceDegrees(fromHct.getHue(), toHct.getHue());
        float rotationDegrees = Math.min(differenceDegrees * 0.5f, 15.0f);
        float outputHue = MathUtils.sanitizeDegrees(fromHct.getHue() + rotationDegrees * Blend.rotationDirection(fromHct.getHue(), toHct.getHue()));
        return Hct.from(outputHue, fromHct.getChroma(), fromHct.getTone()).toInt();
    }

    public static int blendHctHue(int from, int to, float amount) {
        int ucs = Blend.blendCam16Ucs(from, to, amount);
        Cam16 ucsCam = Cam16.fromInt(ucs);
        Cam16 fromCam = Cam16.fromInt(from);
        return Hct.from(ucsCam.getHue(), fromCam.getChroma(), ColorUtils.lstarFromInt(from)).toInt();
    }

    public static int blendCam16Ucs(int from, int to, float amount) {
        Cam16 fromCam = Cam16.fromInt(from);
        Cam16 toCam = Cam16.fromInt(to);
        float aJ = fromCam.getJStar();
        float aA = fromCam.getAStar();
        float aB = fromCam.getBStar();
        float bJ = toCam.getJStar();
        float bA = toCam.getAStar();
        float bB = toCam.getBStar();
        float j = aJ + (bJ - aJ) * amount;
        float a = aA + (bA - aA) * amount;
        float b = aB + (bB - aB) * amount;
        Cam16 blended = Cam16.fromUcs(j, a, b);
        return blended.getInt();
    }

    private static float rotationDirection(float from, float to) {
        float a = to - from;
        float b = to - from + 360.0f;
        float c = to - from - 360.0f;
        float aAbs = Math.abs(a);
        float bAbs = Math.abs(b);
        float cAbs = Math.abs(c);
        if (aAbs <= bAbs && aAbs <= cAbs) {
            return (double)a >= 0.0 ? 1.0f : -1.0f;
        }
        if (bAbs <= aAbs && bAbs <= cAbs) {
            return (double)b >= 0.0 ? 1.0f : -1.0f;
        }
        return (double)c >= 0.0 ? 1.0f : -1.0f;
    }
}

