/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content.res;

import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.res.CamUtils;
import androidx.core.content.res.ViewingConditions;
import androidx.core.graphics.ColorUtils;

class CamColor {
    private static final float DL_MAX = 0.2f;
    private static final float DE_MAX = 1.0f;
    private static final float CHROMA_SEARCH_ENDPOINT = 0.4f;
    private static final float LIGHTNESS_SEARCH_ENDPOINT = 0.01f;
    private final float mHue;
    private final float mChroma;
    private final float mJ;
    private final float mQ;
    private final float mM;
    private final float mS;
    private final float mJstar;
    private final float mAstar;
    private final float mBstar;

    @FloatRange(from=0.0, to=360.0, toInclusive=false)
    float getHue() {
        return this.mHue;
    }

    @FloatRange(from=0.0, to=Infinity, toInclusive=false)
    float getChroma() {
        return this.mChroma;
    }

    @FloatRange(from=0.0, to=100.0)
    float getJ() {
        return this.mJ;
    }

    @FloatRange(from=0.0, to=Infinity, toInclusive=false)
    float getQ() {
        return this.mQ;
    }

    @FloatRange(from=0.0, to=Infinity, toInclusive=false)
    float getM() {
        return this.mM;
    }

    @FloatRange(from=0.0, to=Infinity, toInclusive=false)
    float getS() {
        return this.mS;
    }

    @FloatRange(from=0.0, to=100.0)
    float getJStar() {
        return this.mJstar;
    }

    @FloatRange(from=-Infinity, to=Infinity, fromInclusive=false, toInclusive=false)
    float getAStar() {
        return this.mAstar;
    }

    @FloatRange(from=-Infinity, to=Infinity, fromInclusive=false, toInclusive=false)
    float getBStar() {
        return this.mBstar;
    }

    CamColor(float hue, float chroma, float j, float q, float m, float s, float jStar, float aStar, float bStar) {
        this.mHue = hue;
        this.mChroma = chroma;
        this.mJ = j;
        this.mQ = q;
        this.mM = m;
        this.mS = s;
        this.mJstar = jStar;
        this.mAstar = aStar;
        this.mBstar = bStar;
    }

    static int toColor(@FloatRange(from=0.0, to=360.0) float hue, @FloatRange(from=0.0, to=Infinity, toInclusive=false) float chroma, @FloatRange(from=0.0, to=100.0) float lStar) {
        return CamColor.toColor(hue, chroma, lStar, ViewingConditions.DEFAULT);
    }

    @NonNull
    static CamColor fromColor(@ColorInt int color2) {
        return CamColor.fromColorInViewingConditions(color2, ViewingConditions.DEFAULT);
    }

    @NonNull
    static CamColor fromColorInViewingConditions(@ColorInt int color2, @NonNull ViewingConditions viewingConditions) {
        float[] xyz = CamUtils.xyzFromInt(color2);
        float[][] matrix = CamUtils.XYZ_TO_CAM16RGB;
        float rT = xyz[0] * matrix[0][0] + xyz[1] * matrix[0][1] + xyz[2] * matrix[0][2];
        float gT = xyz[0] * matrix[1][0] + xyz[1] * matrix[1][1] + xyz[2] * matrix[1][2];
        float bT = xyz[0] * matrix[2][0] + xyz[1] * matrix[2][1] + xyz[2] * matrix[2][2];
        float rD = viewingConditions.getRgbD()[0] * rT;
        float gD = viewingConditions.getRgbD()[1] * gT;
        float bD = viewingConditions.getRgbD()[2] * bT;
        float rAF = (float)Math.pow((double)(viewingConditions.getFl() * Math.abs(rD)) / 100.0, 0.42);
        float gAF = (float)Math.pow((double)(viewingConditions.getFl() * Math.abs(gD)) / 100.0, 0.42);
        float bAF = (float)Math.pow((double)(viewingConditions.getFl() * Math.abs(bD)) / 100.0, 0.42);
        float rA = Math.signum(rD) * 400.0f * rAF / (rAF + 27.13f);
        float gA = Math.signum(gD) * 400.0f * gAF / (gAF + 27.13f);
        float bA = Math.signum(bD) * 400.0f * bAF / (bAF + 27.13f);
        float a = (float)(11.0 * (double)rA + -12.0 * (double)gA + (double)bA) / 11.0f;
        float b = (float)((double)(rA + gA) - 2.0 * (double)bA) / 9.0f;
        float u = (20.0f * rA + 20.0f * gA + 21.0f * bA) / 20.0f;
        float p2 = (40.0f * rA + 20.0f * gA + bA) / 20.0f;
        float atan2 = (float)Math.atan2(b, a);
        float atanDegrees = atan2 * 180.0f / (float)Math.PI;
        float hue = atanDegrees < 0.0f ? atanDegrees + 360.0f : (atanDegrees >= 360.0f ? atanDegrees - 360.0f : atanDegrees);
        float hueRadians = hue * (float)Math.PI / 180.0f;
        float ac = p2 * viewingConditions.getNbb();
        float j = 100.0f * (float)Math.pow(ac / viewingConditions.getAw(), viewingConditions.getC() * viewingConditions.getZ());
        float q = 4.0f / viewingConditions.getC() * (float)Math.sqrt(j / 100.0f) * (viewingConditions.getAw() + 4.0f) * viewingConditions.getFlRoot();
        float huePrime = (double)hue < 20.14 ? hue + 360.0f : hue;
        float eHue = 0.25f * (float)(Math.cos((double)huePrime * Math.PI / 180.0 + 2.0) + 3.8);
        float p1 = 3846.1538f * eHue * viewingConditions.getNc() * viewingConditions.getNcb();
        float t = p1 * (float)Math.sqrt(a * a + b * b) / (u + 0.305f);
        float alpha = (float)Math.pow(1.64 - Math.pow(0.29, viewingConditions.getN()), 0.73) * (float)Math.pow(t, 0.9);
        float c = alpha * (float)Math.sqrt((double)j / 100.0);
        float m = c * viewingConditions.getFlRoot();
        float s = 50.0f * (float)Math.sqrt(alpha * viewingConditions.getC() / (viewingConditions.getAw() + 4.0f));
        float jstar = 1.7f * j / (1.0f + 0.007f * j);
        float mstar = 43.85965f * (float)Math.log(1.0f + 0.0228f * m);
        float astar = mstar * (float)Math.cos(hueRadians);
        float bstar = mstar * (float)Math.sin(hueRadians);
        return new CamColor(hue, c, j, q, m, s, jstar, astar, bstar);
    }

    @NonNull
    private static CamColor fromJch(@FloatRange(from=0.0, to=100.0) float j, @FloatRange(from=0.0, to=Infinity, toInclusive=false) float c, @FloatRange(from=0.0, to=360.0) float h) {
        return CamColor.fromJchInFrame(j, c, h, ViewingConditions.DEFAULT);
    }

    @NonNull
    private static CamColor fromJchInFrame(@FloatRange(from=0.0, to=100.0) float j, @FloatRange(from=0.0, to=Infinity, toInclusive=false) float c, @FloatRange(from=0.0, to=360.0) float h, ViewingConditions viewingConditions) {
        float q = 4.0f / viewingConditions.getC() * (float)Math.sqrt((double)j / 100.0) * (viewingConditions.getAw() + 4.0f) * viewingConditions.getFlRoot();
        float m = c * viewingConditions.getFlRoot();
        float alpha = c / (float)Math.sqrt((double)j / 100.0);
        float s = 50.0f * (float)Math.sqrt(alpha * viewingConditions.getC() / (viewingConditions.getAw() + 4.0f));
        float hueRadians = h * (float)Math.PI / 180.0f;
        float jstar = 1.7f * j / (1.0f + 0.007f * j);
        float mstar = 43.85965f * (float)Math.log(1.0 + 0.0228 * (double)m);
        float astar = mstar * (float)Math.cos(hueRadians);
        float bstar = mstar * (float)Math.sin(hueRadians);
        return new CamColor(h, c, j, q, m, s, jstar, astar, bstar);
    }

    float distance(@NonNull CamColor other) {
        float dJ = this.getJStar() - other.getJStar();
        float dA = this.getAStar() - other.getAStar();
        float dB = this.getBStar() - other.getBStar();
        double dEPrime = Math.sqrt(dJ * dJ + dA * dA + dB * dB);
        double dE = 1.41 * Math.pow(dEPrime, 0.63);
        return (float)dE;
    }

    @ColorInt
    int viewedInSrgb() {
        return this.viewed(ViewingConditions.DEFAULT);
    }

    @ColorInt
    int viewed(@NonNull ViewingConditions viewingConditions) {
        float alpha = (double)this.getChroma() == 0.0 || (double)this.getJ() == 0.0 ? 0.0f : this.getChroma() / (float)Math.sqrt((double)this.getJ() / 100.0);
        float t = (float)Math.pow((double)alpha / Math.pow(1.64 - Math.pow(0.29, viewingConditions.getN()), 0.73), 1.1111111111111112);
        float hRad = this.getHue() * (float)Math.PI / 180.0f;
        float eHue = 0.25f * (float)(Math.cos((double)hRad + 2.0) + 3.8);
        float ac = viewingConditions.getAw() * (float)Math.pow((double)this.getJ() / 100.0, 1.0 / (double)viewingConditions.getC() / (double)viewingConditions.getZ());
        float p1 = eHue * 3846.1538f * viewingConditions.getNc() * viewingConditions.getNcb();
        float p2 = ac / viewingConditions.getNbb();
        float hSin = (float)Math.sin(hRad);
        float hCos = (float)Math.cos(hRad);
        float gamma = 23.0f * (p2 + 0.305f) * t / (23.0f * p1 + 11.0f * t * hCos + 108.0f * t * hSin);
        float a = gamma * hCos;
        float b = gamma * hSin;
        float rA = (460.0f * p2 + 451.0f * a + 288.0f * b) / 1403.0f;
        float gA = (460.0f * p2 - 891.0f * a - 261.0f * b) / 1403.0f;
        float bA = (460.0f * p2 - 220.0f * a - 6300.0f * b) / 1403.0f;
        float rCBase = (float)Math.max(0.0, 27.13 * (double)Math.abs(rA) / (400.0 - (double)Math.abs(rA)));
        float rC = Math.signum(rA) * (100.0f / viewingConditions.getFl()) * (float)Math.pow(rCBase, 2.380952380952381);
        float gCBase = (float)Math.max(0.0, 27.13 * (double)Math.abs(gA) / (400.0 - (double)Math.abs(gA)));
        float gC = Math.signum(gA) * (100.0f / viewingConditions.getFl()) * (float)Math.pow(gCBase, 2.380952380952381);
        float bCBase = (float)Math.max(0.0, 27.13 * (double)Math.abs(bA) / (400.0 - (double)Math.abs(bA)));
        float bC = Math.signum(bA) * (100.0f / viewingConditions.getFl()) * (float)Math.pow(bCBase, 2.380952380952381);
        float rF = rC / viewingConditions.getRgbD()[0];
        float gF = gC / viewingConditions.getRgbD()[1];
        float bF = bC / viewingConditions.getRgbD()[2];
        float[][] matrix = CamUtils.CAM16RGB_TO_XYZ;
        float x = rF * matrix[0][0] + gF * matrix[0][1] + bF * matrix[0][2];
        float y = rF * matrix[1][0] + gF * matrix[1][1] + bF * matrix[1][2];
        float z = rF * matrix[2][0] + gF * matrix[2][1] + bF * matrix[2][2];
        int argb = ColorUtils.XYZToColor(x, y, z);
        return argb;
    }

    @ColorInt
    static int toColor(@FloatRange(from=0.0, to=360.0) float hue, @FloatRange(from=0.0, to=Infinity, toInclusive=false) float chroma, @FloatRange(from=0.0, to=100.0) float lstar, @NonNull ViewingConditions viewingConditions) {
        if ((double)chroma < 1.0 || (double)Math.round(lstar) <= 0.0 || (double)Math.round(lstar) >= 100.0) {
            return CamUtils.intFromLStar(lstar);
        }
        hue = hue < 0.0f ? 0.0f : Math.min(360.0f, hue);
        float high = chroma;
        float mid = chroma;
        float low = 0.0f;
        boolean isFirstLoop = true;
        CamColor answer = null;
        while (Math.abs(low - high) >= 0.4f) {
            CamColor possibleAnswer = CamColor.findCamByJ(hue, mid, lstar);
            if (isFirstLoop) {
                if (possibleAnswer != null) {
                    return possibleAnswer.viewed(viewingConditions);
                }
                isFirstLoop = false;
                mid = low + (high - low) / 2.0f;
                continue;
            }
            if (possibleAnswer == null) {
                high = mid;
            } else {
                answer = possibleAnswer;
                low = mid;
            }
            mid = low + (high - low) / 2.0f;
        }
        if (answer == null) {
            return CamUtils.intFromLStar(lstar);
        }
        return answer.viewed(viewingConditions);
    }

    @Nullable
    private static CamColor findCamByJ(@FloatRange(from=0.0, to=360.0) float hue, @FloatRange(from=0.0, to=Infinity, toInclusive=false) float chroma, @FloatRange(from=0.0, to=100.0) float lstar) {
        float low = 0.0f;
        float high = 100.0f;
        float mid = 0.0f;
        float bestdL = 1000.0f;
        float bestdE = 1000.0f;
        CamColor bestCam = null;
        while (Math.abs(low - high) > 0.01f) {
            CamColor camClipped;
            float dE;
            mid = low + (high - low) / 2.0f;
            CamColor camBeforeClip = CamColor.fromJch(mid, chroma, hue);
            int clipped = camBeforeClip.viewedInSrgb();
            float clippedLstar = CamUtils.lStarFromInt(clipped);
            float dL = Math.abs(lstar - clippedLstar);
            if (dL < 0.2f && (dE = (camClipped = CamColor.fromColor(clipped)).distance(CamColor.fromJch(camClipped.getJ(), camClipped.getChroma(), hue))) <= 1.0f) {
                bestdL = dL;
                bestdE = dE;
                bestCam = camClipped;
            }
            if (bestdL == 0.0f && bestdE == 0.0f) break;
            if (clippedLstar < lstar) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return bestCam;
    }
}

