/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout;

import android.app.Activity;
import android.graphics.Rect;
import androidx.window.core.Bounds;
import androidx.window.extensions.layout.DisplayFeature;
import androidx.window.layout.FoldingFeature;
import androidx.window.layout.HardwareFoldingFeature;
import androidx.window.layout.WindowLayoutInfo;
import androidx.window.layout.WindowMetricsCalculatorCompat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u001d\u0010\u0003\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Landroidx/window/layout/ExtensionsWindowLayoutInfoAdapter;", "", "()V", "translate", "Landroidx/window/layout/FoldingFeature;", "activity", "Landroid/app/Activity;", "oemFeature", "Landroidx/window/extensions/layout/FoldingFeature;", "translate$window_release", "Landroidx/window/layout/WindowLayoutInfo;", "info", "Landroidx/window/extensions/layout/WindowLayoutInfo;", "validBounds", "", "bounds", "Landroidx/window/core/Bounds;", "window_release"})
public final class ExtensionsWindowLayoutInfoAdapter {
    @NotNull
    public static final ExtensionsWindowLayoutInfoAdapter INSTANCE = new ExtensionsWindowLayoutInfoAdapter();

    private ExtensionsWindowLayoutInfoAdapter() {
    }

    @Nullable
    public final FoldingFeature translate$window_release(@NotNull Activity activity, @NotNull androidx.window.extensions.layout.FoldingFeature oemFeature) {
        FoldingFeature foldingFeature;
        FoldingFeature.State state;
        HardwareFoldingFeature.Type type;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)oemFeature, (String)"oemFeature");
        switch (oemFeature.getType()) {
            case 1: {
                type = HardwareFoldingFeature.Type.Companion.getFOLD();
                break;
            }
            case 2: {
                type = HardwareFoldingFeature.Type.Companion.getHINGE();
                break;
            }
            default: {
                return null;
            }
        }
        HardwareFoldingFeature.Type type2 = type;
        switch (oemFeature.getState()) {
            case 1: {
                state = FoldingFeature.State.FLAT;
                break;
            }
            case 2: {
                state = FoldingFeature.State.HALF_OPENED;
                break;
            }
            default: {
                return null;
            }
        }
        FoldingFeature.State state2 = state;
        Rect rect = oemFeature.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"oemFeature.bounds");
        Bounds bounds = new Bounds(rect);
        if (this.validBounds(activity, bounds)) {
            rect = oemFeature.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"oemFeature.bounds");
            foldingFeature = new HardwareFoldingFeature(new Bounds(rect), type2, state2);
        } else {
            foldingFeature = null;
        }
        return foldingFeature;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final WindowLayoutInfo translate$window_release(@NotNull Activity activity, @NotNull androidx.window.extensions.layout.WindowLayoutInfo info) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        List list = info.getDisplayFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"info.displayFeatures");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            FoldingFeature foldingFeature;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DisplayFeature feature = (DisplayFeature)element$iv$iv;
            boolean bl2 = false;
            if (feature instanceof androidx.window.extensions.layout.FoldingFeature) {
                Intrinsics.checkNotNullExpressionValue((Object)feature, (String)"feature");
                foldingFeature = INSTANCE.translate$window_release(activity, (androidx.window.extensions.layout.FoldingFeature)feature);
            } else {
                foldingFeature = null;
            }
            if (foldingFeature == null) continue;
            FoldingFeature it$iv$iv = foldingFeature;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List features = (List)destination$iv$iv;
        return new WindowLayoutInfo(features);
    }

    private final boolean validBounds(Activity activity, Bounds bounds) {
        Rect windowBounds = WindowMetricsCalculatorCompat.INSTANCE.computeCurrentWindowMetrics(activity).getBounds();
        if (bounds.isZero()) {
            return false;
        }
        if (bounds.getWidth() != windowBounds.width() && bounds.getHeight() != windowBounds.height()) {
            return false;
        }
        if (bounds.getWidth() < windowBounds.width() && bounds.getHeight() < windowBounds.height()) {
            return false;
        }
        return bounds.getWidth() != windowBounds.width() || bounds.getHeight() != windowBounds.height();
    }
}

