/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.util.Log;
import androidx.window.core.ExperimentalWindowApi;
import androidx.window.embedding.EmbeddingAdapter;
import androidx.window.embedding.EmbeddingInterfaceCompat;
import androidx.window.embedding.EmbeddingRule;
import androidx.window.embedding.EmbeddingTranslatingCallback;
import androidx.window.embedding.EmptyEmbeddingComponent;
import androidx.window.extensions.WindowExtensionsProvider;
import androidx.window.extensions.embedding.ActivityEmbeddingComponent;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/window/embedding/EmbeddingCompat;", "Landroidx/window/embedding/EmbeddingInterfaceCompat;", "()V", "embeddingExtension", "Landroidx/window/extensions/embedding/ActivityEmbeddingComponent;", "adapter", "Landroidx/window/embedding/EmbeddingAdapter;", "(Landroidx/window/extensions/embedding/ActivityEmbeddingComponent;Landroidx/window/embedding/EmbeddingAdapter;)V", "setEmbeddingCallback", "", "embeddingCallback", "Landroidx/window/embedding/EmbeddingInterfaceCompat$EmbeddingCallbackInterface;", "setSplitRules", "rules", "", "Landroidx/window/embedding/EmbeddingRule;", "Companion", "window_release"})
@ExperimentalWindowApi
public final class EmbeddingCompat
implements EmbeddingInterfaceCompat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActivityEmbeddingComponent embeddingExtension;
    @NotNull
    private final EmbeddingAdapter adapter;
    public static final boolean DEBUG = true;
    @NotNull
    private static final String TAG = "EmbeddingCompat";

    public EmbeddingCompat(@NotNull ActivityEmbeddingComponent embeddingExtension, @NotNull EmbeddingAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)embeddingExtension, (String)"embeddingExtension");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        this.embeddingExtension = embeddingExtension;
        this.adapter = adapter;
    }

    public EmbeddingCompat() {
        this(Companion.embeddingComponent(), new EmbeddingAdapter());
    }

    @Override
    public void setSplitRules(@NotNull Set<? extends EmbeddingRule> rules) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        this.embeddingExtension.setEmbeddingRules(this.adapter.translate(rules));
    }

    @Override
    public void setEmbeddingCallback(@NotNull EmbeddingInterfaceCompat.EmbeddingCallbackInterface embeddingCallback) {
        Intrinsics.checkNotNullParameter((Object)embeddingCallback, (String)"embeddingCallback");
        EmbeddingTranslatingCallback translatingCallback = new EmbeddingTranslatingCallback(embeddingCallback, this.adapter);
        this.embeddingExtension.setSplitInfoCallback((Consumer)translatingCallback);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\r\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/window/embedding/EmbeddingCompat$Companion;", "", "()V", "DEBUG", "", "TAG", "", "embeddingComponent", "Landroidx/window/extensions/embedding/ActivityEmbeddingComponent;", "getExtensionApiLevel", "", "()Ljava/lang/Integer;", "isEmbeddingAvailable", "window_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Integer getExtensionApiLevel() {
            Integer n;
            try {
                n = WindowExtensionsProvider.getWindowExtensions().getVendorApiLevel();
            }
            catch (NoClassDefFoundError e) {
                Log.d((String)EmbeddingCompat.TAG, (String)"Embedding extension version not found");
                n = null;
            }
            catch (UnsupportedOperationException e) {
                Log.d((String)EmbeddingCompat.TAG, (String)"Stub Extension");
                n = null;
            }
            return n;
        }

        public final boolean isEmbeddingAvailable() {
            boolean bl;
            try {
                bl = WindowExtensionsProvider.getWindowExtensions().getActivityEmbeddingComponent() != null;
            }
            catch (NoClassDefFoundError e) {
                Log.d((String)EmbeddingCompat.TAG, (String)"Embedding extension version not found");
                bl = false;
            }
            catch (UnsupportedOperationException e) {
                Log.d((String)EmbeddingCompat.TAG, (String)"Stub Extension");
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final ActivityEmbeddingComponent embeddingComponent() {
            ActivityEmbeddingComponent activityEmbeddingComponent;
            return this.isEmbeddingAvailable() ? ((activityEmbeddingComponent = WindowExtensionsProvider.getWindowExtensions().getActivityEmbeddingComponent()) == null ? (ActivityEmbeddingComponent)new EmptyEmbeddingComponent() : activityEmbeddingComponent) : (ActivityEmbeddingComponent)new EmptyEmbeddingComponent();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

