/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.cache;

import com.bumptech.glide.util.Preconditions;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class DiskCacheWriteLocker {
    private final Map<String, WriteLock> locks = new HashMap<String, WriteLock>();
    private final WriteLockPool writeLockPool = new WriteLockPool();

    DiskCacheWriteLocker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquire(String safeKey) {
        WriteLock writeLock;
        DiskCacheWriteLocker diskCacheWriteLocker = this;
        synchronized (diskCacheWriteLocker) {
            writeLock = this.locks.get(safeKey);
            if (writeLock == null) {
                writeLock = this.writeLockPool.obtain();
                this.locks.put(safeKey, writeLock);
            }
            ++writeLock.interestedThreads;
        }
        writeLock.lock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(String safeKey) {
        WriteLock writeLock;
        DiskCacheWriteLocker diskCacheWriteLocker = this;
        synchronized (diskCacheWriteLocker) {
            writeLock = Preconditions.checkNotNull(this.locks.get(safeKey));
            if (writeLock.interestedThreads < 1) {
                throw new IllegalStateException("Cannot release a lock that is not held, safeKey: " + safeKey + ", interestedThreads: " + writeLock.interestedThreads);
            }
            --writeLock.interestedThreads;
            if (writeLock.interestedThreads == 0) {
                WriteLock removed = this.locks.remove(safeKey);
                if (!removed.equals(writeLock)) {
                    throw new IllegalStateException("Removed the wrong lock, expected to remove: " + writeLock + ", but actually removed: " + removed + ", safeKey: " + safeKey);
                }
                this.writeLockPool.offer(removed);
            }
        }
        writeLock.lock.unlock();
    }

    private static class WriteLockPool {
        private static final int MAX_POOL_SIZE = 10;
        private final Queue<WriteLock> pool = new ArrayDeque<WriteLock>();

        WriteLockPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WriteLock obtain() {
            WriteLock result;
            Queue<WriteLock> queue = this.pool;
            synchronized (queue) {
                result = this.pool.poll();
            }
            if (result == null) {
                result = new WriteLock();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void offer(WriteLock writeLock) {
            Queue<WriteLock> queue = this.pool;
            synchronized (queue) {
                if (this.pool.size() < 10) {
                    this.pool.offer(writeLock);
                }
            }
        }
    }

    private static class WriteLock {
        final Lock lock = new ReentrantLock();
        int interestedThreads;

        WriteLock() {
        }
    }
}

