/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import android.os.UserHandle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@RequiresApi(value=17)
public class UserHandleCompat {
    @Nullable
    private static Method sGetUserIdMethod;
    @Nullable
    private static Constructor<UserHandle> sUserHandleConstructor;

    private UserHandleCompat() {
    }

    @NonNull
    public static UserHandle getUserHandleForUid(int uid) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Api24Impl.getUserHandleForUid(uid);
        }
        try {
            Integer userId = (Integer)UserHandleCompat.getGetUserIdMethod().invoke(null, uid);
            return UserHandleCompat.getUserHandleConstructor().newInstance(userId);
        }
        catch (NoSuchMethodException e) {
            NoSuchMethodError error = new NoSuchMethodError();
            error.initCause(e);
            throw error;
        }
        catch (IllegalAccessException e) {
            IllegalAccessError error = new IllegalAccessError();
            error.initCause(e);
            throw error;
        }
        catch (InstantiationException e) {
            InstantiationError error = new InstantiationError();
            error.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method getGetUserIdMethod() throws NoSuchMethodException {
        if (sGetUserIdMethod == null) {
            sGetUserIdMethod = UserHandle.class.getDeclaredMethod("getUserId", Integer.TYPE);
            sGetUserIdMethod.setAccessible(true);
        }
        return sGetUserIdMethod;
    }

    private static Constructor<UserHandle> getUserHandleConstructor() throws NoSuchMethodException {
        if (sUserHandleConstructor == null) {
            sUserHandleConstructor = UserHandle.class.getDeclaredConstructor(Integer.TYPE);
            sUserHandleConstructor.setAccessible(true);
        }
        return sUserHandleConstructor;
    }

    @RequiresApi(value=24)
    private static class Api24Impl {
        private Api24Impl() {
        }

        @NonNull
        static UserHandle getUserHandleForUid(int uid) {
            return UserHandle.getUserHandleForUid((int)uid);
        }
    }
}

