/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import android.app.Application;
import androidx.annotation.MainThread;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.HasDefaultViewModelProviderFactory;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0005\u0014\u0015\u0016\u0017\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ&\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fH\u0097\u0002\u00a2\u0006\u0002\u0010\u0010J.\u0010\u000b\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fH\u0097\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/lifecycle/ViewModelProvider;", "", "owner", "Landroidx/lifecycle/ViewModelStoreOwner;", "(Landroidx/lifecycle/ViewModelStoreOwner;)V", "factory", "Landroidx/lifecycle/ViewModelProvider$Factory;", "(Landroidx/lifecycle/ViewModelStoreOwner;Landroidx/lifecycle/ViewModelProvider$Factory;)V", "store", "Landroidx/lifecycle/ViewModelStore;", "(Landroidx/lifecycle/ViewModelStore;Landroidx/lifecycle/ViewModelProvider$Factory;)V", "get", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "key", "", "(Ljava/lang/String;Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "AndroidViewModelFactory", "Factory", "KeyedFactory", "NewInstanceFactory", "OnRequeryFactory", "lifecycle-viewmodel_release"})
public class ViewModelProvider {
    @NotNull
    private final ViewModelStore store;
    @NotNull
    private final Factory factory;

    public ViewModelProvider(@NotNull ViewModelStore store, @NotNull Factory factory) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.store = store;
        this.factory = factory;
    }

    public ViewModelProvider(@NotNull ViewModelStoreOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        ViewModelStore viewModelStore = owner.getViewModelStore();
        Intrinsics.checkNotNullExpressionValue((Object)viewModelStore, (String)"owner.viewModelStore");
        this(viewModelStore, AndroidViewModelFactory.Companion.defaultFactory$lifecycle_viewmodel_release(owner));
    }

    public ViewModelProvider(@NotNull ViewModelStoreOwner owner, @NotNull Factory factory) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        ViewModelStore viewModelStore = owner.getViewModelStore();
        Intrinsics.checkNotNullExpressionValue((Object)viewModelStore, (String)"owner.viewModelStore");
        this(viewModelStore, factory);
    }

    @MainThread
    @NotNull
    public <T extends ViewModel> T get(@NotNull Class<T> modelClass) {
        Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
        String string = modelClass.getCanonicalName();
        if (string == null) {
            throw new IllegalArgumentException("Local and anonymous classes can not be ViewModels");
        }
        String canonicalName = string;
        return this.get(Intrinsics.stringPlus((String)"androidx.lifecycle.ViewModelProvider.DefaultKey:", (Object)canonicalName), modelClass);
    }

    @MainThread
    @NotNull
    public <T extends ViewModel> T get(@NotNull String key, @NotNull Class<T> modelClass) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
        ViewModel viewModel = this.store.get(key);
        if (modelClass.isInstance(viewModel)) {
            Object object;
            Object object2 = this.factory;
            Object object3 = object = object2 instanceof OnRequeryFactory ? (OnRequeryFactory)object2 : null;
            if (object != null) {
                object2 = viewModel;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"viewModel");
                ((OnRequeryFactory)object).onRequery((ViewModel)object2);
            }
            object = viewModel;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type T of androidx.lifecycle.ViewModelProvider.get");
            }
            return (T)object;
        }
        if (viewModel != null) {
            // empty if block
        }
        viewModel = this.factory instanceof KeyedFactory ? ((KeyedFactory)this.factory).create(key, modelClass) : this.factory.create(modelClass);
        this.store.put(key, viewModel);
        ViewModel viewModel2 = viewModel;
        Intrinsics.checkNotNullExpressionValue((Object)viewModel2, (String)"viewModel");
        return (T)viewModel2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J%\u0010\u0002\u001a\u0002H\u0003\"\b\b\u0000\u0010\u0003*\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0006H&\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/lifecycle/ViewModelProvider$Factory;", "", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "lifecycle-viewmodel_release"})
    public static interface Factory {
        @NotNull
        public <T extends ViewModel> T create(@NotNull Class<T> var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Landroidx/lifecycle/ViewModelProvider$OnRequeryFactory;", "", "()V", "onRequery", "", "viewModel", "Landroidx/lifecycle/ViewModel;", "lifecycle-viewmodel_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class OnRequeryFactory {
        public void onRequery(@NotNull ViewModel viewModel) {
            Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J%\u0010\u0004\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\bH\u0016\u00a2\u0006\u0002\u0010\tJ-\u0010\u0004\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\bH&\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Landroidx/lifecycle/ViewModelProvider$KeyedFactory;", "Landroidx/lifecycle/ViewModelProvider$OnRequeryFactory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "()V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "key", "", "(Ljava/lang/String;Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "lifecycle-viewmodel_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static abstract class KeyedFactory
    extends OnRequeryFactory
    implements Factory {
        @NotNull
        public abstract <T extends ViewModel> T create(@NotNull String var1, @NotNull Class<T> var2);

        @Override
        @NotNull
        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            throw new UnsupportedOperationException("create(String, Class<?>) must be called on implementations of KeyedFactory");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u0002H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0007H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\n"}, d2={"Landroidx/lifecycle/ViewModelProvider$NewInstanceFactory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "()V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "Companion", "lifecycle-viewmodel_release"})
    public static class NewInstanceFactory
    implements Factory {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private static NewInstanceFactory sInstance;

        @Override
        @NotNull
        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            Object object;
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            try {
                object = modelClass.newInstance();
                Intrinsics.checkNotNullExpressionValue(object, (String)"{\n                modelC\u2026wInstance()\n            }");
                object = (ViewModel)object;
            }
            catch (InstantiationException e) {
                throw new RuntimeException(Intrinsics.stringPlus((String)"Cannot create an instance of ", modelClass), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(Intrinsics.stringPlus((String)"Cannot create an instance of ", modelClass), e);
            }
            return object;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public static final NewInstanceFactory getInstance() {
            return Companion.getInstance();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u00048GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/lifecycle/ViewModelProvider$NewInstanceFactory$Companion;", "", "()V", "instance", "Landroidx/lifecycle/ViewModelProvider$NewInstanceFactory;", "getInstance$annotations", "getInstance", "()Landroidx/lifecycle/ViewModelProvider$NewInstanceFactory;", "sInstance", "lifecycle-viewmodel_release"})
        public static final class Companion {
            private Companion() {
            }

            @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
            @NotNull
            public final NewInstanceFactory getInstance() {
                if (sInstance == null) {
                    sInstance = new NewInstanceFactory();
                }
                NewInstanceFactory newInstanceFactory = sInstance;
                Intrinsics.checkNotNull((Object)newInstanceFactory);
                return newInstanceFactory;
            }

            @JvmStatic
            public static /* synthetic */ void getInstance$annotations() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J%\u0010\u0005\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\tH\u0016\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landroidx/lifecycle/ViewModelProvider$AndroidViewModelFactory;", "Landroidx/lifecycle/ViewModelProvider$NewInstanceFactory;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "Companion", "lifecycle-viewmodel_release"})
    public static class AndroidViewModelFactory
    extends NewInstanceFactory {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Application application;
        @NotNull
        public static final String DEFAULT_KEY = "androidx.lifecycle.ViewModelProvider.DefaultKey";
        @Nullable
        private static AndroidViewModelFactory sInstance;

        public AndroidViewModelFactory(@NotNull Application application) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            this.application = application;
        }

        @Override
        @NotNull
        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            Object object;
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            if (AndroidViewModel.class.isAssignableFrom(modelClass)) {
                Object object2;
                try {
                    object2 = new Class[]{Application.class};
                    Constructor<T> constructor = modelClass.getConstructor((Class<?>[])object2);
                    object2 = new Object[]{this.application};
                    object2 = (ViewModel)constructor.newInstance(object2);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(Intrinsics.stringPlus((String)"Cannot create an instance of ", modelClass), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(Intrinsics.stringPlus((String)"Cannot create an instance of ", modelClass), e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(Intrinsics.stringPlus((String)"Cannot create an instance of ", modelClass), e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(Intrinsics.stringPlus((String)"Cannot create an instance of ", modelClass), e);
                }
                Object object3 = object2;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"{\n                try {\n\u2026          }\n            }");
                object = object3;
            } else {
                object = super.create(modelClass);
            }
            return object;
        }

        @JvmStatic
        @NotNull
        public static final AndroidViewModelFactory getInstance(@NotNull Application application) {
            return Companion.getInstance(application);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/lifecycle/ViewModelProvider$AndroidViewModelFactory$Companion;", "", "()V", "DEFAULT_KEY", "", "sInstance", "Landroidx/lifecycle/ViewModelProvider$AndroidViewModelFactory;", "defaultFactory", "Landroidx/lifecycle/ViewModelProvider$Factory;", "owner", "Landroidx/lifecycle/ViewModelStoreOwner;", "defaultFactory$lifecycle_viewmodel_release", "getInstance", "application", "Landroid/app/Application;", "lifecycle-viewmodel_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Factory defaultFactory$lifecycle_viewmodel_release(@NotNull ViewModelStoreOwner owner) {
                Factory factory;
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                if (owner instanceof HasDefaultViewModelProviderFactory) {
                    Factory factory2 = ((HasDefaultViewModelProviderFactory)((Object)owner)).getDefaultViewModelProviderFactory();
                    Intrinsics.checkNotNullExpressionValue((Object)factory2, (String)"owner.defaultViewModelProviderFactory");
                    factory = factory2;
                } else {
                    factory = NewInstanceFactory.Companion.getInstance();
                }
                return factory;
            }

            @JvmStatic
            @NotNull
            public final AndroidViewModelFactory getInstance(@NotNull Application application) {
                Intrinsics.checkNotNullParameter((Object)application, (String)"application");
                if (sInstance == null) {
                    sInstance = new AndroidViewModelFactory(application);
                }
                AndroidViewModelFactory androidViewModelFactory = sInstance;
                Intrinsics.checkNotNull((Object)androidViewModelFactory);
                return androidViewModelFactory;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

