/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink;

import com.google.crypto.tink.Catalogue;
import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.KeyManagerImpl;
import com.google.crypto.tink.KeyTypeManager;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.PrivateKeyManager;
import com.google.crypto.tink.PrivateKeyManagerImpl;
import com.google.crypto.tink.PrivateKeyTypeManager;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.KeyTemplate;
import com.google.crypto.tink.shaded.protobuf.ByteString;
import com.google.crypto.tink.shaded.protobuf.InvalidProtocolBufferException;
import com.google.crypto.tink.shaded.protobuf.MessageLite;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

public final class Registry {
    private static final Logger logger = Logger.getLogger(Registry.class.getName());
    private static final ConcurrentMap<String, KeyManagerContainer> keyManagerMap = new ConcurrentHashMap<String, KeyManagerContainer>();
    private static final ConcurrentMap<String, KeyDeriverContainer> keyDeriverMap = new ConcurrentHashMap<String, KeyDeriverContainer>();
    private static final ConcurrentMap<String, Boolean> newKeyAllowedMap = new ConcurrentHashMap<String, Boolean>();
    private static final ConcurrentMap<String, Catalogue<?>> catalogueMap = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, PrimitiveWrapper<?, ?>> primitiveWrapperMap = new ConcurrentHashMap();
    private static final ConcurrentMap<String, com.google.crypto.tink.KeyTemplate> keyTemplateMap = new ConcurrentHashMap<String, com.google.crypto.tink.KeyTemplate>();

    private static <P> KeyManagerContainer createContainerFor(KeyManager<P> keyManager) {
        final KeyManager<P> localKeyManager = keyManager;
        return new KeyManagerContainer(){

            public <Q> KeyManager<Q> getKeyManager(Class<Q> primitiveClass) throws GeneralSecurityException {
                if (!localKeyManager.getPrimitiveClass().equals(primitiveClass)) {
                    throw new InternalError("This should never be called, as we always first check supportedPrimitives.");
                }
                KeyManager result = localKeyManager;
                return result;
            }

            @Override
            public KeyManager<?> getUntypedKeyManager() {
                return localKeyManager;
            }

            @Override
            public Class<?> getImplementingClass() {
                return localKeyManager.getClass();
            }

            @Override
            public Set<Class<?>> supportedPrimitives() {
                return Collections.singleton(localKeyManager.getPrimitiveClass());
            }

            @Override
            public Class<?> publicKeyManagerClassOrNull() {
                return null;
            }

            @Override
            public MessageLite parseKey(ByteString serializedKey) throws GeneralSecurityException, InvalidProtocolBufferException {
                return null;
            }
        };
    }

    private static <KeyProtoT extends MessageLite> KeyManagerContainer createContainerFor(KeyTypeManager<KeyProtoT> keyManager) {
        final KeyTypeManager<KeyProtoT> localKeyManager = keyManager;
        return new KeyManagerContainer(){

            public <Q> KeyManager<Q> getKeyManager(Class<Q> primitiveClass) throws GeneralSecurityException {
                try {
                    return new KeyManagerImpl(localKeyManager, primitiveClass);
                }
                catch (IllegalArgumentException e) {
                    throw new GeneralSecurityException("Primitive type not supported", e);
                }
            }

            @Override
            public KeyManager<?> getUntypedKeyManager() {
                return new KeyManagerImpl(localKeyManager, localKeyManager.firstSupportedPrimitiveClass());
            }

            @Override
            public Class<?> getImplementingClass() {
                return localKeyManager.getClass();
            }

            @Override
            public Set<Class<?>> supportedPrimitives() {
                return localKeyManager.supportedPrimitives();
            }

            @Override
            public Class<?> publicKeyManagerClassOrNull() {
                return null;
            }

            @Override
            public MessageLite parseKey(ByteString serializedKey) throws GeneralSecurityException, InvalidProtocolBufferException {
                Object result = localKeyManager.parseKey(serializedKey);
                localKeyManager.validateKey(result);
                return result;
            }
        };
    }

    private static <KeyProtoT extends MessageLite, PublicKeyProtoT extends MessageLite> KeyManagerContainer createPrivateKeyContainerFor(PrivateKeyTypeManager<KeyProtoT, PublicKeyProtoT> privateKeyTypeManager, KeyTypeManager<PublicKeyProtoT> publicKeyTypeManager) {
        final PrivateKeyTypeManager<KeyProtoT, PublicKeyProtoT> localPrivateKeyManager = privateKeyTypeManager;
        final KeyTypeManager<PublicKeyProtoT> localPublicKeyManager = publicKeyTypeManager;
        return new KeyManagerContainer(){

            public <Q> KeyManager<Q> getKeyManager(Class<Q> primitiveClass) throws GeneralSecurityException {
                try {
                    return new PrivateKeyManagerImpl(localPrivateKeyManager, localPublicKeyManager, primitiveClass);
                }
                catch (IllegalArgumentException e) {
                    throw new GeneralSecurityException("Primitive type not supported", e);
                }
            }

            @Override
            public KeyManager<?> getUntypedKeyManager() {
                return new PrivateKeyManagerImpl(localPrivateKeyManager, localPublicKeyManager, localPrivateKeyManager.firstSupportedPrimitiveClass());
            }

            @Override
            public Class<?> getImplementingClass() {
                return localPrivateKeyManager.getClass();
            }

            @Override
            public Set<Class<?>> supportedPrimitives() {
                return localPrivateKeyManager.supportedPrimitives();
            }

            @Override
            public Class<?> publicKeyManagerClassOrNull() {
                return localPublicKeyManager.getClass();
            }

            @Override
            public MessageLite parseKey(ByteString serializedKey) throws GeneralSecurityException, InvalidProtocolBufferException {
                Object result = localPrivateKeyManager.parseKey(serializedKey);
                localPrivateKeyManager.validateKey(result);
                return result;
            }
        };
    }

    private static <KeyProtoT extends MessageLite> KeyDeriverContainer createDeriverFor(final KeyTypeManager<KeyProtoT> keyManager) {
        return new KeyDeriverContainer(){

            private <KeyFormatProtoT extends MessageLite> MessageLite deriveKeyWithFactory(ByteString serializedKeyFormat, InputStream stream, KeyTypeManager.KeyFactory<KeyFormatProtoT, KeyProtoT> keyFactory) throws GeneralSecurityException {
                KeyFormatProtoT keyFormat;
                try {
                    keyFormat = keyFactory.parseKeyFormat(serializedKeyFormat);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new GeneralSecurityException("parsing key format failed in deriveKey", e);
                }
                keyFactory.validateKeyFormat(keyFormat);
                return (MessageLite)keyFactory.deriveKey(keyFormat, stream);
            }

            @Override
            public KeyData deriveKey(ByteString serializedKeyFormat, InputStream stream) throws GeneralSecurityException {
                KeyTypeManager.KeyFactory keyFactory = keyManager.keyFactory();
                MessageLite keyValue = this.deriveKeyWithFactory(serializedKeyFormat, stream, keyFactory);
                return (KeyData)KeyData.newBuilder().setTypeUrl(keyManager.getKeyType()).setValue(keyValue.toByteString()).setKeyMaterialType(keyManager.keyMaterialType()).build();
            }
        };
    }

    private static synchronized KeyManagerContainer getKeyManagerContainerOrThrow(String typeUrl) throws GeneralSecurityException {
        if (!keyManagerMap.containsKey(typeUrl)) {
            throw new GeneralSecurityException("No key manager found for key type " + typeUrl);
        }
        return (KeyManagerContainer)keyManagerMap.get(typeUrl);
    }

    static synchronized void reset() {
        keyManagerMap.clear();
        keyDeriverMap.clear();
        newKeyAllowedMap.clear();
        catalogueMap.clear();
        primitiveWrapperMap.clear();
        keyTemplateMap.clear();
    }

    @Deprecated
    public static synchronized void addCatalogue(String catalogueName, Catalogue<?> catalogue) throws GeneralSecurityException {
        if (catalogueName == null) {
            throw new IllegalArgumentException("catalogueName must be non-null.");
        }
        if (catalogue == null) {
            throw new IllegalArgumentException("catalogue must be non-null.");
        }
        if (catalogueMap.containsKey(catalogueName.toLowerCase(Locale.US))) {
            Catalogue existing = (Catalogue)catalogueMap.get(catalogueName.toLowerCase(Locale.US));
            if (!catalogue.getClass().getName().equals(existing.getClass().getName())) {
                logger.warning("Attempted overwrite of a catalogueName catalogue for name " + catalogueName);
                throw new GeneralSecurityException("catalogue for name " + catalogueName + " has been already registered");
            }
        }
        catalogueMap.put(catalogueName.toLowerCase(Locale.US), catalogue);
    }

    @Deprecated
    public static Catalogue<?> getCatalogue(String catalogueName) throws GeneralSecurityException {
        if (catalogueName == null) {
            throw new IllegalArgumentException("catalogueName must be non-null.");
        }
        Catalogue catalogue = (Catalogue)catalogueMap.get(catalogueName.toLowerCase(Locale.US));
        if (catalogue == null) {
            String error = String.format("no catalogue found for %s. ", catalogueName);
            if (catalogueName.toLowerCase(Locale.US).startsWith("tinkaead")) {
                error = error + "Maybe call AeadConfig.register().";
            }
            if (catalogueName.toLowerCase(Locale.US).startsWith("tinkdeterministicaead")) {
                error = error + "Maybe call DeterministicAeadConfig.register().";
            } else if (catalogueName.toLowerCase(Locale.US).startsWith("tinkstreamingaead")) {
                error = error + "Maybe call StreamingAeadConfig.register().";
            } else if (catalogueName.toLowerCase(Locale.US).startsWith("tinkhybriddecrypt") || catalogueName.toLowerCase(Locale.US).startsWith("tinkhybridencrypt")) {
                error = error + "Maybe call HybridConfig.register().";
            } else if (catalogueName.toLowerCase(Locale.US).startsWith("tinkmac")) {
                error = error + "Maybe call MacConfig.register().";
            } else if (catalogueName.toLowerCase(Locale.US).startsWith("tinkpublickeysign") || catalogueName.toLowerCase(Locale.US).startsWith("tinkpublickeyverify")) {
                error = error + "Maybe call SignatureConfig.register().";
            } else if (catalogueName.toLowerCase(Locale.US).startsWith("tink")) {
                error = error + "Maybe call TinkConfig.register().";
            }
            throw new GeneralSecurityException(error);
        }
        return catalogue;
    }

    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static synchronized <P> void registerKeyManager(KeyManager<P> manager) throws GeneralSecurityException {
        Registry.registerKeyManager(manager, true);
    }

    private static synchronized <KeyProtoT extends MessageLite, KeyFormatProtoT extends MessageLite> void ensureKeyManagerInsertable(String typeUrl, Class<?> implementingClass, Map<String, KeyTypeManager.KeyFactory.KeyFormat<KeyFormatProtoT>> keyFormats, boolean newKeyAllowed) throws GeneralSecurityException {
        block6: {
            KeyManagerContainer container = (KeyManagerContainer)keyManagerMap.get(typeUrl);
            if (container != null && !container.getImplementingClass().equals(implementingClass)) {
                logger.warning("Attempted overwrite of a registered key manager for key type " + typeUrl);
                throw new GeneralSecurityException(String.format("typeUrl (%s) is already registered with %s, cannot be re-registered with %s", typeUrl, container.getImplementingClass().getName(), implementingClass.getName()));
            }
            if (newKeyAllowed && newKeyAllowedMap.containsKey(typeUrl) && !((Boolean)newKeyAllowedMap.get(typeUrl)).booleanValue()) {
                throw new GeneralSecurityException("New keys are already disallowed for key type " + typeUrl);
            }
            if (!newKeyAllowed) break block6;
            if (keyManagerMap.containsKey(typeUrl)) {
                for (Map.Entry<String, KeyTypeManager.KeyFactory.KeyFormat<KeyFormatProtoT>> entry : keyFormats.entrySet()) {
                    if (keyTemplateMap.containsKey(entry.getKey())) continue;
                    throw new GeneralSecurityException("Attempted to register a new key template " + entry.getKey() + " from an existing key manager of type " + typeUrl);
                }
            } else {
                for (Map.Entry<String, KeyTypeManager.KeyFactory.KeyFormat<KeyFormatProtoT>> entry : keyFormats.entrySet()) {
                    if (!keyTemplateMap.containsKey(entry.getKey())) continue;
                    throw new GeneralSecurityException("Attempted overwrite of a registered key template " + entry.getKey());
                }
            }
        }
    }

    public static synchronized <P> void registerKeyManager(KeyManager<P> manager, boolean newKeyAllowed) throws GeneralSecurityException {
        if (manager == null) {
            throw new IllegalArgumentException("key manager must be non-null.");
        }
        String typeUrl = manager.getKeyType();
        Registry.ensureKeyManagerInsertable(typeUrl, manager.getClass(), Collections.emptyMap(), newKeyAllowed);
        keyManagerMap.putIfAbsent(typeUrl, Registry.createContainerFor(manager));
        newKeyAllowedMap.put(typeUrl, newKeyAllowed);
    }

    public static synchronized <KeyProtoT extends MessageLite> void registerKeyManager(KeyTypeManager<KeyProtoT> manager, boolean newKeyAllowed) throws GeneralSecurityException {
        if (manager == null) {
            throw new IllegalArgumentException("key manager must be non-null.");
        }
        String typeUrl = manager.getKeyType();
        Registry.ensureKeyManagerInsertable(typeUrl, manager.getClass(), newKeyAllowed ? manager.keyFactory().keyFormats() : Collections.emptyMap(), newKeyAllowed);
        if (!keyManagerMap.containsKey(typeUrl)) {
            keyManagerMap.put(typeUrl, Registry.createContainerFor(manager));
            keyDeriverMap.put(typeUrl, Registry.createDeriverFor(manager));
            if (newKeyAllowed) {
                Registry.registerKeyTemplates(typeUrl, manager.keyFactory().keyFormats());
            }
        }
        newKeyAllowedMap.put(typeUrl, newKeyAllowed);
    }

    public static synchronized <KeyProtoT extends MessageLite, PublicKeyProtoT extends MessageLite> void registerAsymmetricKeyManagers(PrivateKeyTypeManager<KeyProtoT, PublicKeyProtoT> privateKeyTypeManager, KeyTypeManager<PublicKeyProtoT> publicKeyTypeManager, boolean newKeyAllowed) throws GeneralSecurityException {
        Class<?> existingPublicKeyManagerClass;
        if (privateKeyTypeManager == null || publicKeyTypeManager == null) {
            throw new IllegalArgumentException("given key managers must be non-null.");
        }
        String privateTypeUrl = privateKeyTypeManager.getKeyType();
        String publicTypeUrl = publicKeyTypeManager.getKeyType();
        Registry.ensureKeyManagerInsertable(privateTypeUrl, privateKeyTypeManager.getClass(), newKeyAllowed ? privateKeyTypeManager.keyFactory().keyFormats() : Collections.emptyMap(), newKeyAllowed);
        Registry.ensureKeyManagerInsertable(publicTypeUrl, publicKeyTypeManager.getClass(), Collections.emptyMap(), false);
        if (privateTypeUrl.equals(publicTypeUrl)) {
            throw new GeneralSecurityException("Private and public key type must be different.");
        }
        if (keyManagerMap.containsKey(privateTypeUrl) && (existingPublicKeyManagerClass = ((KeyManagerContainer)keyManagerMap.get(privateTypeUrl)).publicKeyManagerClassOrNull()) != null && !existingPublicKeyManagerClass.getName().equals(publicKeyTypeManager.getClass().getName())) {
            logger.warning("Attempted overwrite of a registered key manager for key type " + privateTypeUrl + " with inconsistent public key type " + publicTypeUrl);
            throw new GeneralSecurityException(String.format("public key manager corresponding to %s is already registered with %s, cannot be re-registered with %s", privateKeyTypeManager.getClass().getName(), existingPublicKeyManagerClass.getName(), publicKeyTypeManager.getClass().getName()));
        }
        if (!keyManagerMap.containsKey(privateTypeUrl) || ((KeyManagerContainer)keyManagerMap.get(privateTypeUrl)).publicKeyManagerClassOrNull() == null) {
            keyManagerMap.put(privateTypeUrl, Registry.createPrivateKeyContainerFor(privateKeyTypeManager, publicKeyTypeManager));
            keyDeriverMap.put(privateTypeUrl, Registry.createDeriverFor(privateKeyTypeManager));
            if (newKeyAllowed) {
                Registry.registerKeyTemplates(privateKeyTypeManager.getKeyType(), privateKeyTypeManager.keyFactory().keyFormats());
            }
        }
        newKeyAllowedMap.put(privateTypeUrl, newKeyAllowed);
        if (!keyManagerMap.containsKey(publicTypeUrl)) {
            keyManagerMap.put(publicTypeUrl, Registry.createContainerFor(publicKeyTypeManager));
        }
        newKeyAllowedMap.put(publicTypeUrl, false);
    }

    private static <KeyFormatProtoT extends MessageLite> void registerKeyTemplates(String typeUrl, Map<String, KeyTypeManager.KeyFactory.KeyFormat<KeyFormatProtoT>> keyFormats) {
        for (Map.Entry<String, KeyTypeManager.KeyFactory.KeyFormat<KeyFormatProtoT>> entry : keyFormats.entrySet()) {
            keyTemplateMap.put(entry.getKey(), com.google.crypto.tink.KeyTemplate.create(typeUrl, ((MessageLite)entry.getValue().keyFormat).toByteArray(), entry.getValue().outputPrefixType));
        }
    }

    @Deprecated
    public static synchronized <P> void registerKeyManager(String typeUrl, KeyManager<P> manager) throws GeneralSecurityException {
        Registry.registerKeyManager(typeUrl, manager, true);
    }

    @Deprecated
    public static synchronized <P> void registerKeyManager(String typeUrl, KeyManager<P> manager, boolean newKeyAllowed) throws GeneralSecurityException {
        if (manager == null) {
            throw new IllegalArgumentException("key manager must be non-null.");
        }
        if (!typeUrl.equals(manager.getKeyType())) {
            throw new GeneralSecurityException("Manager does not support key type " + typeUrl + ".");
        }
        Registry.registerKeyManager(manager, newKeyAllowed);
    }

    public static synchronized <B, P> void registerPrimitiveWrapper(PrimitiveWrapper<B, P> wrapper) throws GeneralSecurityException {
        if (wrapper == null) {
            throw new IllegalArgumentException("wrapper must be non-null");
        }
        Class<P> classObject = wrapper.getPrimitiveClass();
        if (primitiveWrapperMap.containsKey(classObject)) {
            PrimitiveWrapper existingWrapper = (PrimitiveWrapper)primitiveWrapperMap.get(classObject);
            if (!wrapper.getClass().getName().equals(existingWrapper.getClass().getName())) {
                logger.warning("Attempted overwrite of a registered PrimitiveWrapper for type " + classObject);
                throw new GeneralSecurityException(String.format("PrimitiveWrapper for primitive (%s) is already registered to be %s, cannot be re-registered with %s", classObject.getName(), existingWrapper.getClass().getName(), wrapper.getClass().getName()));
            }
        }
        primitiveWrapperMap.put(classObject, wrapper);
    }

    @Deprecated
    public static <P> KeyManager<P> getKeyManager(String typeUrl) throws GeneralSecurityException {
        return Registry.getKeyManagerInternal(typeUrl, null);
    }

    public static KeyManager<?> getUntypedKeyManager(String typeUrl) throws GeneralSecurityException {
        KeyManagerContainer container = Registry.getKeyManagerContainerOrThrow(typeUrl);
        return container.getUntypedKeyManager();
    }

    public static <P> KeyManager<P> getKeyManager(String typeUrl, Class<P> primitiveClass) throws GeneralSecurityException {
        return Registry.getKeyManagerInternal(typeUrl, Registry.checkNotNull(primitiveClass));
    }

    private static String toCommaSeparatedString(Set<Class<?>> setOfClasses) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Class<?> clazz : setOfClasses) {
            if (!first) {
                b.append(", ");
            }
            b.append(clazz.getCanonicalName());
            first = false;
        }
        return b.toString();
    }

    private static <P> KeyManager<P> getKeyManagerInternal(String typeUrl, Class<P> primitiveClass) throws GeneralSecurityException {
        KeyManagerContainer container = Registry.getKeyManagerContainerOrThrow(typeUrl);
        if (primitiveClass == null) {
            KeyManager<?> result = container.getUntypedKeyManager();
            return result;
        }
        if (container.supportedPrimitives().contains(primitiveClass)) {
            return container.getKeyManager(primitiveClass);
        }
        throw new GeneralSecurityException("Primitive type " + primitiveClass.getName() + " not supported by key manager of type " + container.getImplementingClass() + ", supported primitives: " + Registry.toCommaSeparatedString(container.supportedPrimitives()));
    }

    public static synchronized KeyData newKeyData(KeyTemplate keyTemplate) throws GeneralSecurityException {
        KeyManager<?> manager = Registry.getUntypedKeyManager(keyTemplate.getTypeUrl());
        if (((Boolean)newKeyAllowedMap.get(keyTemplate.getTypeUrl())).booleanValue()) {
            return manager.newKeyData(keyTemplate.getValue());
        }
        throw new GeneralSecurityException("newKey-operation not permitted for key type " + keyTemplate.getTypeUrl());
    }

    public static synchronized KeyData newKeyData(com.google.crypto.tink.KeyTemplate keyTemplate) throws GeneralSecurityException {
        return Registry.newKeyData(keyTemplate.getProto());
    }

    public static synchronized MessageLite newKey(KeyTemplate keyTemplate) throws GeneralSecurityException {
        KeyManager<?> manager = Registry.getUntypedKeyManager(keyTemplate.getTypeUrl());
        if (((Boolean)newKeyAllowedMap.get(keyTemplate.getTypeUrl())).booleanValue()) {
            return manager.newKey(keyTemplate.getValue());
        }
        throw new GeneralSecurityException("newKey-operation not permitted for key type " + keyTemplate.getTypeUrl());
    }

    public static synchronized MessageLite newKey(String typeUrl, MessageLite format) throws GeneralSecurityException {
        KeyManager manager = Registry.getKeyManager(typeUrl);
        if (((Boolean)newKeyAllowedMap.get(typeUrl)).booleanValue()) {
            return manager.newKey(format);
        }
        throw new GeneralSecurityException("newKey-operation not permitted for key type " + typeUrl);
    }

    static synchronized KeyData deriveKey(KeyTemplate keyTemplate, InputStream randomStream) throws GeneralSecurityException {
        String typeUrl = keyTemplate.getTypeUrl();
        if (!keyDeriverMap.containsKey(typeUrl)) {
            throw new GeneralSecurityException("No keymanager registered or key manager cannot derive keys for " + typeUrl);
        }
        KeyDeriverContainer deriver = (KeyDeriverContainer)keyDeriverMap.get(typeUrl);
        return deriver.deriveKey(keyTemplate.getValue(), randomStream);
    }

    public static KeyData getPublicKeyData(String typeUrl, ByteString serializedPrivateKey) throws GeneralSecurityException {
        KeyManager manager = Registry.getKeyManager(typeUrl);
        if (!(manager instanceof PrivateKeyManager)) {
            throw new GeneralSecurityException("manager for key type " + typeUrl + " is not a PrivateKeyManager");
        }
        return ((PrivateKeyManager)manager).getPublicKeyData(serializedPrivateKey);
    }

    @Deprecated
    public static <P> P getPrimitive(String typeUrl, MessageLite key) throws GeneralSecurityException {
        return Registry.getPrimitiveInternal(typeUrl, key, null);
    }

    public static <P> P getPrimitive(String typeUrl, MessageLite key, Class<P> primitiveClass) throws GeneralSecurityException {
        return Registry.getPrimitiveInternal(typeUrl, key, Registry.checkNotNull(primitiveClass));
    }

    private static <P> P getPrimitiveInternal(String typeUrl, MessageLite key, Class<P> primitiveClass) throws GeneralSecurityException {
        KeyManager<P> manager = Registry.getKeyManagerInternal(typeUrl, primitiveClass);
        return manager.getPrimitive(key);
    }

    @Deprecated
    public static <P> P getPrimitive(String typeUrl, ByteString serializedKey) throws GeneralSecurityException {
        return Registry.getPrimitiveInternal(typeUrl, serializedKey, null);
    }

    public static <P> P getPrimitive(String typeUrl, ByteString serializedKey, Class<P> primitiveClass) throws GeneralSecurityException {
        return Registry.getPrimitiveInternal(typeUrl, serializedKey, Registry.checkNotNull(primitiveClass));
    }

    private static <P> P getPrimitiveInternal(String typeUrl, ByteString serializedKey, Class<P> primitiveClass) throws GeneralSecurityException {
        KeyManager<P> manager = Registry.getKeyManagerInternal(typeUrl, primitiveClass);
        return manager.getPrimitive(serializedKey);
    }

    @Deprecated
    public static <P> P getPrimitive(String typeUrl, byte[] serializedKey) throws GeneralSecurityException {
        return Registry.getPrimitive(typeUrl, ByteString.copyFrom(serializedKey));
    }

    public static <P> P getPrimitive(String typeUrl, byte[] serializedKey, Class<P> primitiveClass) throws GeneralSecurityException {
        return Registry.getPrimitive(typeUrl, ByteString.copyFrom(serializedKey), primitiveClass);
    }

    @Deprecated
    public static <P> P getPrimitive(KeyData keyData) throws GeneralSecurityException {
        return Registry.getPrimitive(keyData.getTypeUrl(), keyData.getValue());
    }

    public static <P> P getPrimitive(KeyData keyData, Class<P> primitiveClass) throws GeneralSecurityException {
        return Registry.getPrimitive(keyData.getTypeUrl(), keyData.getValue(), primitiveClass);
    }

    public static <B, P> P wrap(PrimitiveSet<B> primitiveSet, Class<P> clazz) throws GeneralSecurityException {
        PrimitiveWrapper wrapper = (PrimitiveWrapper)primitiveWrapperMap.get(clazz);
        if (wrapper == null) {
            throw new GeneralSecurityException("No wrapper found for " + primitiveSet.getPrimitiveClass().getName());
        }
        if (!wrapper.getInputPrimitiveClass().equals(primitiveSet.getPrimitiveClass())) {
            throw new GeneralSecurityException("Wrong input primitive class, expected " + wrapper.getInputPrimitiveClass() + ", got " + primitiveSet.getPrimitiveClass());
        }
        Object result = wrapper.wrap(primitiveSet);
        return result;
    }

    public static <P> P wrap(PrimitiveSet<P> primitiveSet) throws GeneralSecurityException {
        return Registry.wrap(primitiveSet, primitiveSet.getPrimitiveClass());
    }

    public static synchronized List<String> keyTemplates() {
        ArrayList<String> results = new ArrayList<String>();
        for (String name : keyTemplateMap.keySet()) {
            results.add(name);
        }
        return Collections.unmodifiableList(results);
    }

    static synchronized Map<String, com.google.crypto.tink.KeyTemplate> keyTemplateMap() {
        return Collections.unmodifiableMap(keyTemplateMap);
    }

    public static Class<?> getInputPrimitive(Class<?> wrappedPrimitive) {
        PrimitiveWrapper wrapper = (PrimitiveWrapper)primitiveWrapperMap.get(wrappedPrimitive);
        if (wrapper == null) {
            return null;
        }
        return wrapper.getInputPrimitiveClass();
    }

    static MessageLite parseKeyData(KeyData keyData) throws GeneralSecurityException, InvalidProtocolBufferException {
        KeyManagerContainer container = Registry.getKeyManagerContainerOrThrow(keyData.getTypeUrl());
        return container.parseKey(keyData.getValue());
    }

    private Registry() {
    }

    private static interface KeyDeriverContainer {
        public KeyData deriveKey(ByteString var1, InputStream var2) throws GeneralSecurityException;
    }

    private static interface KeyManagerContainer {
        public <P> KeyManager<P> getKeyManager(Class<P> var1) throws GeneralSecurityException;

        public KeyManager<?> getUntypedKeyManager();

        public Class<?> getImplementingClass();

        public Set<Class<?>> supportedPrimitives();

        public Class<?> publicKeyManagerClassOrNull();

        public MessageLite parseKey(ByteString var1) throws GeneralSecurityException, InvalidProtocolBufferException;
    }
}

