/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.trusted;

import android.annotation.SuppressLint;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.pm.SigningInfo;
import android.os.Build;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.browser.trusted.TokenContents;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

class PackageIdentityUtils {
    private static final String TAG = "PackageIdentity";

    private PackageIdentityUtils() {
    }

    @Nullable
    static List<byte[]> getFingerprintsForPackage(String name, PackageManager pm) {
        try {
            return PackageIdentityUtils.getImpl().getFingerprintsForPackage(name, pm);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Could not get fingerprint for package.", (Throwable)e);
            return null;
        }
    }

    static boolean packageMatchesToken(String name, PackageManager pm, TokenContents token) {
        try {
            return PackageIdentityUtils.getImpl().packageMatchesToken(name, pm, token);
        }
        catch (PackageManager.NameNotFoundException | IOException e) {
            Log.e((String)TAG, (String)"Could not check if package matches token.", (Throwable)e);
            return false;
        }
    }

    private static SignaturesCompat getImpl() {
        if (Build.VERSION.SDK_INT >= 28) {
            return new Api28Implementation();
        }
        return new Pre28Implementation();
    }

    @Nullable
    static byte[] getCertificateSHA256Fingerprint(Signature signature) {
        try {
            return MessageDigest.getInstance("SHA256").digest(signature.toByteArray());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    static class Pre28Implementation
    implements SignaturesCompat {
        Pre28Implementation() {
        }

        @Override
        @SuppressLint(value={"PackageManagerGetSignatures"})
        @Nullable
        public List<byte[]> getFingerprintsForPackage(String name, PackageManager pm) throws PackageManager.NameNotFoundException {
            PackageInfo packageInfo = pm.getPackageInfo(name, 64);
            ArrayList<byte[]> fingerprints = new ArrayList<byte[]>(packageInfo.signatures.length);
            for (Signature signature : packageInfo.signatures) {
                byte[] fingerprint = PackageIdentityUtils.getCertificateSHA256Fingerprint(signature);
                if (fingerprint == null) {
                    return null;
                }
                fingerprints.add(fingerprint);
            }
            return fingerprints;
        }

        @Override
        public boolean packageMatchesToken(String name, PackageManager pm, TokenContents token) throws IOException, PackageManager.NameNotFoundException {
            if (!name.equals(token.getPackageName())) {
                return false;
            }
            List<byte[]> fingerprints = this.getFingerprintsForPackage(name, pm);
            if (fingerprints == null) {
                return false;
            }
            TokenContents contents = TokenContents.create(name, fingerprints);
            return token.equals(contents);
        }
    }

    @RequiresApi(value=28)
    static class Api28Implementation
    implements SignaturesCompat {
        Api28Implementation() {
        }

        @Override
        @Nullable
        public List<byte[]> getFingerprintsForPackage(String name, PackageManager pm) throws PackageManager.NameNotFoundException {
            PackageInfo packageInfo = pm.getPackageInfo(name, 0x8000000);
            ArrayList<byte[]> fingerprints = new ArrayList<byte[]>();
            SigningInfo signingInfo = packageInfo.signingInfo;
            if (signingInfo.hasMultipleSigners()) {
                for (Signature signature : signingInfo.getApkContentsSigners()) {
                    fingerprints.add(PackageIdentityUtils.getCertificateSHA256Fingerprint(signature));
                }
            } else {
                fingerprints.add(PackageIdentityUtils.getCertificateSHA256Fingerprint(signingInfo.getSigningCertificateHistory()[0]));
            }
            return fingerprints;
        }

        @Override
        public boolean packageMatchesToken(String name, PackageManager pm, TokenContents token) throws PackageManager.NameNotFoundException, IOException {
            if (!token.getPackageName().equals(name)) {
                return false;
            }
            List<byte[]> fingerprints = this.getFingerprintsForPackage(name, pm);
            if (fingerprints == null) {
                return false;
            }
            if (fingerprints.size() == 1) {
                return pm.hasSigningCertificate(name, token.getFingerprint(0), 1);
            }
            TokenContents contents = TokenContents.create(name, fingerprints);
            return token.equals(contents);
        }
    }

    static interface SignaturesCompat {
        @Nullable
        public List<byte[]> getFingerprintsForPackage(String var1, PackageManager var2) throws PackageManager.NameNotFoundException;

        public boolean packageMatchesToken(String var1, PackageManager var2, TokenContents var3) throws IOException, PackageManager.NameNotFoundException;
    }
}

