/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomnavigation;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.google.android.material.R;
import com.google.android.material.bottomnavigation.BottomNavigationMenuView;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.navigation.NavigationBarMenuView;
import com.google.android.material.navigation.NavigationBarView;
import com.google.android.material.shape.MaterialShapeDrawable;

public class BottomNavigationView
extends NavigationBarView {
    static final int MAX_ITEM_COUNT = 5;

    public BottomNavigationView(@NonNull Context context) {
        this(context, null);
    }

    public BottomNavigationView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.bottomNavigationStyle);
    }

    public BottomNavigationView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, R.style.Widget_Design_BottomNavigationView);
    }

    public BottomNavigationView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        context = this.getContext();
        TintTypedArray attributes = ThemeEnforcement.obtainTintedStyledAttributes(context, attrs, R.styleable.BottomNavigationView, defStyleAttr, defStyleRes, new int[0]);
        this.setItemHorizontalTranslationEnabled(attributes.getBoolean(R.styleable.BottomNavigationView_itemHorizontalTranslationEnabled, true));
        if (attributes.hasValue(R.styleable.BottomNavigationView_android_minHeight)) {
            this.setMinimumHeight(attributes.getDimensionPixelSize(R.styleable.BottomNavigationView_android_minHeight, 0));
        }
        attributes.recycle();
        if (this.shouldDrawCompatibilityTopDivider()) {
            this.addCompatibilityTopDivider(context);
        }
        this.applyWindowInsets();
    }

    private void applyWindowInsets() {
        ViewUtils.doOnApplyWindowInsets((View)this, new ViewUtils.OnApplyWindowInsetsListener(){

            @Override
            @NonNull
            public WindowInsetsCompat onApplyWindowInsets(View view, @NonNull WindowInsetsCompat insets, @NonNull ViewUtils.RelativePadding initialPadding) {
                initialPadding.bottom += insets.getSystemWindowInsetBottom();
                boolean isRtl = ViewCompat.getLayoutDirection((View)view) == 1;
                int systemWindowInsetLeft = insets.getSystemWindowInsetLeft();
                int systemWindowInsetRight = insets.getSystemWindowInsetRight();
                initialPadding.start = initialPadding.start + (isRtl ? systemWindowInsetRight : systemWindowInsetLeft);
                initialPadding.end = initialPadding.end + (isRtl ? systemWindowInsetLeft : systemWindowInsetRight);
                initialPadding.applyToView(view);
                return insets;
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minHeightSpec = this.makeMinHeightSpec(heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, minHeightSpec);
    }

    private int makeMinHeightSpec(int measureSpec) {
        int minHeight = this.getSuggestedMinimumHeight();
        if (View.MeasureSpec.getMode((int)measureSpec) != 0x40000000 && minHeight > 0) {
            return View.MeasureSpec.makeMeasureSpec((int)Math.min(View.MeasureSpec.getSize((int)measureSpec), minHeight += this.getPaddingTop() + this.getPaddingBottom()), (int)0x40000000);
        }
        return measureSpec;
    }

    public void setItemHorizontalTranslationEnabled(boolean itemHorizontalTranslationEnabled) {
        BottomNavigationMenuView menuView = (BottomNavigationMenuView)this.getMenuView();
        if (menuView.isItemHorizontalTranslationEnabled() != itemHorizontalTranslationEnabled) {
            menuView.setItemHorizontalTranslationEnabled(itemHorizontalTranslationEnabled);
            this.getPresenter().updateMenuView(false);
        }
    }

    public boolean isItemHorizontalTranslationEnabled() {
        return ((BottomNavigationMenuView)this.getMenuView()).isItemHorizontalTranslationEnabled();
    }

    @Override
    public int getMaxItemCount() {
        return 5;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    protected NavigationBarMenuView createNavigationBarMenuView(@NonNull Context context) {
        return new BottomNavigationMenuView(context);
    }

    private boolean shouldDrawCompatibilityTopDivider() {
        return Build.VERSION.SDK_INT < 21 && !(this.getBackground() instanceof MaterialShapeDrawable);
    }

    private void addCompatibilityTopDivider(@NonNull Context context) {
        View divider = new View(context);
        divider.setBackgroundColor(ContextCompat.getColor((Context)context, (int)R.color.design_bottom_navigation_shadow_color));
        FrameLayout.LayoutParams dividerParams = new FrameLayout.LayoutParams(-1, this.getResources().getDimensionPixelSize(R.dimen.design_bottom_navigation_shadow_height));
        divider.setLayoutParams((ViewGroup.LayoutParams)dividerParams);
        this.addView(divider);
    }

    @Deprecated
    public void setOnNavigationItemSelectedListener(@Nullable OnNavigationItemSelectedListener listener) {
        this.setOnItemSelectedListener(listener);
    }

    @Deprecated
    public void setOnNavigationItemReselectedListener(@Nullable OnNavigationItemReselectedListener listener) {
        this.setOnItemReselectedListener(listener);
    }

    @Deprecated
    public static interface OnNavigationItemReselectedListener
    extends NavigationBarView.OnItemReselectedListener {
    }

    @Deprecated
    public static interface OnNavigationItemSelectedListener
    extends NavigationBarView.OnItemSelectedListener {
    }
}

