/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.os.Build;
import androidx.annotation.NonNull;
import java.util.ArrayList;

class AnimatorUtils {
    static void addPauseListener(@NonNull Animator animator, @NonNull AnimatorListenerAdapter listener) {
        if (Build.VERSION.SDK_INT >= 19) {
            animator.addPauseListener((Animator.AnimatorPauseListener)listener);
        }
    }

    static void pause(@NonNull Animator animator) {
        if (Build.VERSION.SDK_INT >= 19) {
            animator.pause();
        } else {
            ArrayList listeners = animator.getListeners();
            if (listeners != null) {
                int size = listeners.size();
                for (int i = 0; i < size; ++i) {
                    Animator.AnimatorListener listener = (Animator.AnimatorListener)listeners.get(i);
                    if (!(listener instanceof AnimatorPauseListenerCompat)) continue;
                    ((AnimatorPauseListenerCompat)listener).onAnimationPause(animator);
                }
            }
        }
    }

    static void resume(@NonNull Animator animator) {
        if (Build.VERSION.SDK_INT >= 19) {
            animator.resume();
        } else {
            ArrayList listeners = animator.getListeners();
            if (listeners != null) {
                int size = listeners.size();
                for (int i = 0; i < size; ++i) {
                    Animator.AnimatorListener listener = (Animator.AnimatorListener)listeners.get(i);
                    if (!(listener instanceof AnimatorPauseListenerCompat)) continue;
                    ((AnimatorPauseListenerCompat)listener).onAnimationResume(animator);
                }
            }
        }
    }

    private AnimatorUtils() {
    }

    static interface AnimatorPauseListenerCompat {
        public void onAnimationPause(Animator var1);

        public void onAnimationResume(Animator var1);
    }
}

