/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import androidx.window.core.ExperimentalWindowApi;
import androidx.window.embedding.MatcherUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014J\b\u0010\u0019\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001a"}, d2={"Landroidx/window/embedding/SplitPairFilter;", "", "primaryActivityName", "Landroid/content/ComponentName;", "secondaryActivityName", "secondaryActivityIntentAction", "", "(Landroid/content/ComponentName;Landroid/content/ComponentName;Ljava/lang/String;)V", "getPrimaryActivityName", "()Landroid/content/ComponentName;", "getSecondaryActivityIntentAction", "()Ljava/lang/String;", "getSecondaryActivityName", "equals", "", "other", "hashCode", "", "matchesActivityIntentPair", "primaryActivity", "Landroid/app/Activity;", "secondaryActivityIntent", "Landroid/content/Intent;", "matchesActivityPair", "secondaryActivity", "toString", "window_release"})
@ExperimentalWindowApi
public final class SplitPairFilter {
    @NotNull
    private final ComponentName primaryActivityName;
    @NotNull
    private final ComponentName secondaryActivityName;
    @Nullable
    private final String secondaryActivityIntentAction;

    public SplitPairFilter(@NotNull ComponentName primaryActivityName, @NotNull ComponentName secondaryActivityName, @Nullable String secondaryActivityIntentAction) {
        Intrinsics.checkNotNullParameter((Object)primaryActivityName, (String)"primaryActivityName");
        Intrinsics.checkNotNullParameter((Object)secondaryActivityName, (String)"secondaryActivityName");
        this.primaryActivityName = primaryActivityName;
        this.secondaryActivityName = secondaryActivityName;
        this.secondaryActivityIntentAction = secondaryActivityIntentAction;
        String string = this.primaryActivityName.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"primaryActivityName.packageName");
        String primaryPackageName = string;
        String string2 = this.primaryActivityName.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"primaryActivityName.className");
        String primaryClassName = string2;
        String string3 = this.secondaryActivityName.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"secondaryActivityName.packageName");
        String secondaryPackageName = string3;
        String string4 = this.secondaryActivityName.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"secondaryActivityName.className");
        String secondaryClassName = string4;
        if (!(!(((CharSequence)primaryPackageName).length() == 0) && !(((CharSequence)secondaryPackageName).length() == 0))) {
            boolean $i$a$-require-SplitPairFilter$72 = false;
            String $i$a$-require-SplitPairFilter$72 = "Package name must not be empty";
            throw new IllegalArgumentException($i$a$-require-SplitPairFilter$72.toString());
        }
        if (!(!(((CharSequence)primaryClassName).length() == 0) && !(((CharSequence)secondaryClassName).length() == 0))) {
            boolean $i$a$-require-SplitPairFilter$82 = false;
            String $i$a$-require-SplitPairFilter$82 = "Activity class name must not be empty.";
            throw new IllegalArgumentException($i$a$-require-SplitPairFilter$82.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)primaryPackageName, (CharSequence)"*", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)primaryPackageName, (String)"*", (int)0, (boolean)false, (int)6, null) == primaryPackageName.length() - 1)) {
            boolean $i$a$-require-SplitPairFilter$92 = false;
            String $i$a$-require-SplitPairFilter$92 = "Wildcard in package name is only allowed at the end.";
            throw new IllegalArgumentException($i$a$-require-SplitPairFilter$92.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)primaryClassName, (CharSequence)"*", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)primaryClassName, (String)"*", (int)0, (boolean)false, (int)6, null) == primaryClassName.length() - 1)) {
            boolean $i$a$-require-SplitPairFilter$102 = false;
            String $i$a$-require-SplitPairFilter$102 = "Wildcard in class name is only allowed at the end.";
            throw new IllegalArgumentException($i$a$-require-SplitPairFilter$102.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)secondaryPackageName, (CharSequence)"*", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)secondaryPackageName, (String)"*", (int)0, (boolean)false, (int)6, null) == secondaryPackageName.length() - 1)) {
            boolean $i$a$-require-SplitPairFilter$112 = false;
            String $i$a$-require-SplitPairFilter$112 = "Wildcard in package name is only allowed at the end.";
            throw new IllegalArgumentException($i$a$-require-SplitPairFilter$112.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)secondaryClassName, (CharSequence)"*", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)secondaryClassName, (String)"*", (int)0, (boolean)false, (int)6, null) == secondaryClassName.length() - 1)) {
            boolean bl = false;
            String string5 = "Wildcard in class name is only allowed at the end.";
            throw new IllegalArgumentException(string5.toString());
        }
    }

    @NotNull
    public final ComponentName getPrimaryActivityName() {
        return this.primaryActivityName;
    }

    @NotNull
    public final ComponentName getSecondaryActivityName() {
        return this.secondaryActivityName;
    }

    @Nullable
    public final String getSecondaryActivityIntentAction() {
        return this.secondaryActivityIntentAction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matchesActivityPair(@NotNull Activity primaryActivity, @NotNull Activity secondaryActivity) {
        Intrinsics.checkNotNullParameter((Object)primaryActivity, (String)"primaryActivity");
        Intrinsics.checkNotNullParameter((Object)secondaryActivity, (String)"secondaryActivity");
        boolean match = MatcherUtils.INSTANCE.areComponentsMatching$window_release(primaryActivity.getComponentName(), this.primaryActivityName) && MatcherUtils.INSTANCE.areComponentsMatching$window_release(secondaryActivity.getComponentName(), this.secondaryActivityName);
        if (secondaryActivity.getIntent() == null) return match;
        if (!match) return false;
        Intent intent = secondaryActivity.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"secondaryActivity.intent");
        if (!this.matchesActivityIntentPair(primaryActivity, intent)) return false;
        return true;
    }

    public final boolean matchesActivityIntentPair(@NotNull Activity primaryActivity, @NotNull Intent secondaryActivityIntent) {
        Intrinsics.checkNotNullParameter((Object)primaryActivity, (String)"primaryActivity");
        Intrinsics.checkNotNullParameter((Object)secondaryActivityIntent, (String)"secondaryActivityIntent");
        ComponentName inPrimaryActivityName = primaryActivity.getComponentName();
        boolean match = !MatcherUtils.INSTANCE.areComponentsMatching$window_release(inPrimaryActivityName, this.primaryActivityName) ? false : (!MatcherUtils.INSTANCE.areComponentsMatching$window_release(secondaryActivityIntent.getComponent(), this.secondaryActivityName) ? false : this.secondaryActivityIntentAction == null || Intrinsics.areEqual((Object)this.secondaryActivityIntentAction, (Object)secondaryActivityIntent.getAction()));
        return match;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SplitPairFilter)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.primaryActivityName, (Object)((SplitPairFilter)other).primaryActivityName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.secondaryActivityName, (Object)((SplitPairFilter)other).secondaryActivityName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.secondaryActivityIntentAction, (Object)((SplitPairFilter)other).secondaryActivityIntentAction);
    }

    public int hashCode() {
        int n;
        int result = this.primaryActivityName.hashCode();
        result = 31 * result + this.secondaryActivityName.hashCode();
        String string = this.secondaryActivityIntentAction;
        result = 31 * result + (string == null ? 0 : (n = string.hashCode()));
        return result;
    }

    @NotNull
    public String toString() {
        return "SplitPairFilter{primaryActivityName=" + this.primaryActivityName + ", secondaryActivityName=" + this.secondaryActivityName + ", secondaryActivityAction=" + this.secondaryActivityIntentAction + '}';
    }
}

