/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.manager;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArrayMap;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.GlideExperiments;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.resource.bitmap.HardwareConfigState;
import com.bumptech.glide.manager.ApplicationLifecycle;
import com.bumptech.glide.manager.DoNothingFirstFrameWaiter;
import com.bumptech.glide.manager.EmptyRequestManagerTreeNode;
import com.bumptech.glide.manager.FirstFrameAndAfterTrimMemoryWaiter;
import com.bumptech.glide.manager.FirstFrameWaiter;
import com.bumptech.glide.manager.FrameWaiter;
import com.bumptech.glide.manager.Lifecycle;
import com.bumptech.glide.manager.RequestManagerFragment;
import com.bumptech.glide.manager.RequestManagerTreeNode;
import com.bumptech.glide.manager.SupportRequestManagerFragment;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RequestManagerRetriever
implements Handler.Callback {
    @VisibleForTesting
    static final String FRAGMENT_TAG = "com.bumptech.glide.manager";
    private static final String TAG = "RMRetriever";
    private static final int ID_REMOVE_FRAGMENT_MANAGER = 1;
    private static final int ID_REMOVE_SUPPORT_FRAGMENT_MANAGER = 2;
    private static final String FRAGMENT_INDEX_KEY = "key";
    private volatile RequestManager applicationManager;
    @VisibleForTesting
    final Map<FragmentManager, RequestManagerFragment> pendingRequestManagerFragments = new HashMap<FragmentManager, RequestManagerFragment>();
    @VisibleForTesting
    final Map<androidx.fragment.app.FragmentManager, SupportRequestManagerFragment> pendingSupportRequestManagerFragments = new HashMap<androidx.fragment.app.FragmentManager, SupportRequestManagerFragment>();
    private final Handler handler;
    private final RequestManagerFactory factory;
    private final ArrayMap<View, androidx.fragment.app.Fragment> tempViewToSupportFragment = new ArrayMap();
    private final ArrayMap<View, Fragment> tempViewToFragment = new ArrayMap();
    private final Bundle tempBundle = new Bundle();
    private final FrameWaiter frameWaiter;
    private static final RequestManagerFactory DEFAULT_FACTORY = new RequestManagerFactory(){

        @Override
        @NonNull
        public RequestManager build(@NonNull Glide glide, @NonNull Lifecycle lifecycle, @NonNull RequestManagerTreeNode requestManagerTreeNode, @NonNull Context context) {
            return new RequestManager(glide, lifecycle, requestManagerTreeNode, context);
        }
    };

    public RequestManagerRetriever(@Nullable RequestManagerFactory factory, GlideExperiments experiments) {
        this.factory = factory != null ? factory : DEFAULT_FACTORY;
        this.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        this.frameWaiter = RequestManagerRetriever.buildFrameWaiter(experiments);
    }

    private static FrameWaiter buildFrameWaiter(GlideExperiments experiments) {
        if (!HardwareConfigState.HARDWARE_BITMAPS_SUPPORTED || !HardwareConfigState.BLOCK_HARDWARE_BITMAPS_WHEN_GL_CONTEXT_MIGHT_NOT_BE_INITIALIZED) {
            return new DoNothingFirstFrameWaiter();
        }
        return experiments.isEnabled(GlideBuilder.WaitForFramesAfterTrimMemory.class) ? new FirstFrameAndAfterTrimMemoryWaiter() : new FirstFrameWaiter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private RequestManager getApplicationManager(@NonNull Context context) {
        if (this.applicationManager == null) {
            RequestManagerRetriever requestManagerRetriever = this;
            synchronized (requestManagerRetriever) {
                if (this.applicationManager == null) {
                    Glide glide = Glide.get(context.getApplicationContext());
                    this.applicationManager = this.factory.build(glide, new ApplicationLifecycle(), new EmptyRequestManagerTreeNode(), context.getApplicationContext());
                }
            }
        }
        return this.applicationManager;
    }

    @NonNull
    public RequestManager get(@NonNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("You cannot start a load on a null Context");
        }
        if (Util.isOnMainThread() && !(context instanceof Application)) {
            if (context instanceof FragmentActivity) {
                return this.get((FragmentActivity)context);
            }
            if (context instanceof Activity) {
                return this.get((Activity)context);
            }
            if (context instanceof ContextWrapper && ((ContextWrapper)context).getBaseContext().getApplicationContext() != null) {
                return this.get(((ContextWrapper)context).getBaseContext());
            }
        }
        return this.getApplicationManager(context);
    }

    @NonNull
    public RequestManager get(@NonNull FragmentActivity activity) {
        if (Util.isOnBackgroundThread()) {
            return this.get(activity.getApplicationContext());
        }
        RequestManagerRetriever.assertNotDestroyed((Activity)activity);
        this.frameWaiter.registerSelf((Activity)activity);
        androidx.fragment.app.FragmentManager fm = activity.getSupportFragmentManager();
        return this.supportFragmentGet((Context)activity, fm, null, RequestManagerRetriever.isActivityVisible((Context)activity));
    }

    @NonNull
    public RequestManager get(@NonNull androidx.fragment.app.Fragment fragment) {
        Preconditions.checkNotNull(fragment.getContext(), "You cannot start a load on a fragment before it is attached or after it is destroyed");
        if (Util.isOnBackgroundThread()) {
            return this.get(fragment.getContext().getApplicationContext());
        }
        if (fragment.getActivity() != null) {
            this.frameWaiter.registerSelf((Activity)fragment.getActivity());
        }
        androidx.fragment.app.FragmentManager fm = fragment.getChildFragmentManager();
        return this.supportFragmentGet(fragment.getContext(), fm, fragment, fragment.isVisible());
    }

    @NonNull
    public RequestManager get(@NonNull Activity activity) {
        if (Util.isOnBackgroundThread()) {
            return this.get(activity.getApplicationContext());
        }
        if (activity instanceof FragmentActivity) {
            return this.get((FragmentActivity)activity);
        }
        RequestManagerRetriever.assertNotDestroyed(activity);
        this.frameWaiter.registerSelf(activity);
        FragmentManager fm = activity.getFragmentManager();
        return this.fragmentGet((Context)activity, fm, null, RequestManagerRetriever.isActivityVisible((Context)activity));
    }

    @NonNull
    public RequestManager get(@NonNull View view) {
        if (Util.isOnBackgroundThread()) {
            return this.get(view.getContext().getApplicationContext());
        }
        Preconditions.checkNotNull(view);
        Preconditions.checkNotNull(view.getContext(), "Unable to obtain a request manager for a view without a Context");
        Activity activity = RequestManagerRetriever.findActivity(view.getContext());
        if (activity == null) {
            return this.get(view.getContext().getApplicationContext());
        }
        if (activity instanceof FragmentActivity) {
            androidx.fragment.app.Fragment fragment = this.findSupportFragment(view, (FragmentActivity)activity);
            return fragment != null ? this.get(fragment) : this.get((FragmentActivity)activity);
        }
        Fragment fragment = this.findFragment(view, activity);
        if (fragment == null) {
            return this.get(activity);
        }
        return this.get(fragment);
    }

    private static void findAllSupportFragmentsWithViews(@Nullable Collection<androidx.fragment.app.Fragment> topLevelFragments, @NonNull Map<View, androidx.fragment.app.Fragment> result) {
        if (topLevelFragments == null) {
            return;
        }
        for (androidx.fragment.app.Fragment fragment : topLevelFragments) {
            if (fragment == null || fragment.getView() == null) continue;
            result.put(fragment.getView(), fragment);
            RequestManagerRetriever.findAllSupportFragmentsWithViews(fragment.getChildFragmentManager().getFragments(), result);
        }
    }

    @Nullable
    private androidx.fragment.app.Fragment findSupportFragment(@NonNull View target, @NonNull FragmentActivity activity) {
        this.tempViewToSupportFragment.clear();
        RequestManagerRetriever.findAllSupportFragmentsWithViews(activity.getSupportFragmentManager().getFragments(), this.tempViewToSupportFragment);
        androidx.fragment.app.Fragment result = null;
        View activityRoot = activity.findViewById(0x1020002);
        View current = target;
        while (!current.equals(activityRoot) && (result = (androidx.fragment.app.Fragment)this.tempViewToSupportFragment.get((Object)current)) == null && current.getParent() instanceof View) {
            current = (View)current.getParent();
        }
        this.tempViewToSupportFragment.clear();
        return result;
    }

    @Deprecated
    @Nullable
    private Fragment findFragment(@NonNull View target, @NonNull Activity activity) {
        this.tempViewToFragment.clear();
        this.findAllFragmentsWithViews(activity.getFragmentManager(), this.tempViewToFragment);
        Fragment result = null;
        View activityRoot = activity.findViewById(0x1020002);
        View current = target;
        while (!current.equals(activityRoot) && (result = (Fragment)this.tempViewToFragment.get((Object)current)) == null && current.getParent() instanceof View) {
            current = (View)current.getParent();
        }
        this.tempViewToFragment.clear();
        return result;
    }

    @Deprecated
    @TargetApi(value=26)
    private void findAllFragmentsWithViews(@NonNull FragmentManager fragmentManager, @NonNull ArrayMap<View, Fragment> result) {
        if (Build.VERSION.SDK_INT >= 26) {
            for (Fragment fragment : fragmentManager.getFragments()) {
                if (fragment.getView() == null) continue;
                result.put((Object)fragment.getView(), (Object)fragment);
                this.findAllFragmentsWithViews(fragment.getChildFragmentManager(), result);
            }
        } else {
            this.findAllFragmentsWithViewsPreO(fragmentManager, result);
        }
    }

    @Deprecated
    private void findAllFragmentsWithViewsPreO(@NonNull FragmentManager fragmentManager, @NonNull ArrayMap<View, Fragment> result) {
        int index = 0;
        while (true) {
            this.tempBundle.putInt(FRAGMENT_INDEX_KEY, index++);
            Fragment fragment = null;
            try {
                fragment = fragmentManager.getFragment(this.tempBundle, FRAGMENT_INDEX_KEY);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fragment == null) break;
            if (fragment.getView() == null) continue;
            result.put((Object)fragment.getView(), (Object)fragment);
            if (Build.VERSION.SDK_INT < 17) continue;
            this.findAllFragmentsWithViews(fragment.getChildFragmentManager(), result);
        }
    }

    @Nullable
    private static Activity findActivity(@NonNull Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return RequestManagerRetriever.findActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    @TargetApi(value=17)
    private static void assertNotDestroyed(@NonNull Activity activity) {
        if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
            throw new IllegalArgumentException("You cannot start a load for a destroyed activity");
        }
    }

    @Deprecated
    @NonNull
    @TargetApi(value=17)
    public RequestManager get(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null) {
            throw new IllegalArgumentException("You cannot start a load on a fragment before it is attached");
        }
        if (Util.isOnBackgroundThread() || Build.VERSION.SDK_INT < 17) {
            return this.get(fragment.getActivity().getApplicationContext());
        }
        if (fragment.getActivity() != null) {
            this.frameWaiter.registerSelf(fragment.getActivity());
        }
        FragmentManager fm = fragment.getChildFragmentManager();
        return this.fragmentGet((Context)fragment.getActivity(), fm, fragment, fragment.isVisible());
    }

    @Deprecated
    @NonNull
    RequestManagerFragment getRequestManagerFragment(Activity activity) {
        return this.getRequestManagerFragment(activity.getFragmentManager(), null);
    }

    @NonNull
    private RequestManagerFragment getRequestManagerFragment(@NonNull FragmentManager fm, @Nullable Fragment parentHint) {
        RequestManagerFragment current = (RequestManagerFragment)fm.findFragmentByTag(FRAGMENT_TAG);
        if (current == null && (current = this.pendingRequestManagerFragments.get(fm)) == null) {
            current = new RequestManagerFragment();
            current.setParentFragmentHint(parentHint);
            this.pendingRequestManagerFragments.put(fm, current);
            fm.beginTransaction().add((Fragment)current, FRAGMENT_TAG).commitAllowingStateLoss();
            this.handler.obtainMessage(1, (Object)fm).sendToTarget();
        }
        return current;
    }

    @Deprecated
    @NonNull
    private RequestManager fragmentGet(@NonNull Context context, @NonNull FragmentManager fm, @Nullable Fragment parentHint, boolean isParentVisible) {
        RequestManagerFragment current = this.getRequestManagerFragment(fm, parentHint);
        RequestManager requestManager = current.getRequestManager();
        if (requestManager == null) {
            Glide glide = Glide.get(context);
            requestManager = this.factory.build(glide, current.getGlideLifecycle(), current.getRequestManagerTreeNode(), context);
            if (isParentVisible) {
                requestManager.onStart();
            }
            current.setRequestManager(requestManager);
        }
        return requestManager;
    }

    @NonNull
    SupportRequestManagerFragment getSupportRequestManagerFragment(androidx.fragment.app.FragmentManager fragmentManager) {
        return this.getSupportRequestManagerFragment(fragmentManager, null);
    }

    private static boolean isActivityVisible(Context context) {
        Activity activity = RequestManagerRetriever.findActivity(context);
        return activity == null || !activity.isFinishing();
    }

    @NonNull
    private SupportRequestManagerFragment getSupportRequestManagerFragment(@NonNull androidx.fragment.app.FragmentManager fm, @Nullable androidx.fragment.app.Fragment parentHint) {
        SupportRequestManagerFragment current = (SupportRequestManagerFragment)fm.findFragmentByTag(FRAGMENT_TAG);
        if (current == null && (current = this.pendingSupportRequestManagerFragments.get(fm)) == null) {
            current = new SupportRequestManagerFragment();
            current.setParentFragmentHint(parentHint);
            this.pendingSupportRequestManagerFragments.put(fm, current);
            fm.beginTransaction().add((androidx.fragment.app.Fragment)current, FRAGMENT_TAG).commitAllowingStateLoss();
            this.handler.obtainMessage(2, (Object)fm).sendToTarget();
        }
        return current;
    }

    @NonNull
    private RequestManager supportFragmentGet(@NonNull Context context, @NonNull androidx.fragment.app.FragmentManager fm, @Nullable androidx.fragment.app.Fragment parentHint, boolean isParentVisible) {
        SupportRequestManagerFragment current = this.getSupportRequestManagerFragment(fm, parentHint);
        RequestManager requestManager = current.getRequestManager();
        if (requestManager == null) {
            Glide glide = Glide.get(context);
            requestManager = this.factory.build(glide, current.getGlideLifecycle(), current.getRequestManagerTreeNode(), context);
            if (isParentVisible) {
                requestManager.onStart();
            }
            current.setRequestManager(requestManager);
        }
        return requestManager;
    }

    public boolean handleMessage(Message message) {
        boolean handled = true;
        Object removed = null;
        FragmentManager key = null;
        switch (message.what) {
            case 1: {
                FragmentManager fm;
                key = fm = (FragmentManager)message.obj;
                removed = this.pendingRequestManagerFragments.remove(fm);
                break;
            }
            case 2: {
                androidx.fragment.app.FragmentManager supportFm = (androidx.fragment.app.FragmentManager)message.obj;
                key = supportFm;
                removed = this.pendingSupportRequestManagerFragments.remove(supportFm);
                break;
            }
            default: {
                handled = false;
            }
        }
        if (handled && removed == null && Log.isLoggable((String)TAG, (int)5)) {
            Log.w((String)TAG, (String)("Failed to remove expected request manager fragment, manager: " + key));
        }
        return handled;
    }

    public static interface RequestManagerFactory {
        @NonNull
        public RequestManager build(@NonNull Glide var1, @NonNull Lifecycle var2, @NonNull RequestManagerTreeNode var3, @NonNull Context var4);
    }
}

