/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model.stream;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.data.mediastore.MediaStoreUtil;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoaderFactory;
import com.bumptech.glide.signature.ObjectKey;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;

@RequiresApi(value=29)
public final class QMediaStoreUriLoader<DataT>
implements ModelLoader<Uri, DataT> {
    private final Context context;
    private final ModelLoader<File, DataT> fileDelegate;
    private final ModelLoader<Uri, DataT> uriDelegate;
    private final Class<DataT> dataClass;

    QMediaStoreUriLoader(Context context, ModelLoader<File, DataT> fileDelegate, ModelLoader<Uri, DataT> uriDelegate, Class<DataT> dataClass) {
        this.context = context.getApplicationContext();
        this.fileDelegate = fileDelegate;
        this.uriDelegate = uriDelegate;
        this.dataClass = dataClass;
    }

    @Override
    public ModelLoader.LoadData<DataT> buildLoadData(@NonNull Uri uri, int width, int height, @NonNull Options options) {
        return new ModelLoader.LoadData<DataT>(new ObjectKey(uri), new QMediaStoreUriFetcher<DataT>(this.context, this.fileDelegate, this.uriDelegate, uri, width, height, options, this.dataClass));
    }

    @Override
    public boolean handles(@NonNull Uri uri) {
        return Build.VERSION.SDK_INT >= 29 && MediaStoreUtil.isMediaStoreUri(uri);
    }

    private static abstract class Factory<DataT>
    implements ModelLoaderFactory<Uri, DataT> {
        private final Context context;
        private final Class<DataT> dataClass;

        Factory(Context context, Class<DataT> dataClass) {
            this.context = context;
            this.dataClass = dataClass;
        }

        @Override
        @NonNull
        public final ModelLoader<Uri, DataT> build(@NonNull MultiModelLoaderFactory multiFactory) {
            return new QMediaStoreUriLoader<DataT>(this.context, multiFactory.build(File.class, this.dataClass), multiFactory.build(Uri.class, this.dataClass), this.dataClass);
        }

        @Override
        public final void teardown() {
        }
    }

    @RequiresApi(value=29)
    public static final class FileDescriptorFactory
    extends Factory<ParcelFileDescriptor> {
        public FileDescriptorFactory(Context context) {
            super(context, ParcelFileDescriptor.class);
        }
    }

    @RequiresApi(value=29)
    public static final class InputStreamFactory
    extends Factory<InputStream> {
        public InputStreamFactory(Context context) {
            super(context, InputStream.class);
        }
    }

    private static final class QMediaStoreUriFetcher<DataT>
    implements DataFetcher<DataT> {
        private static final String[] PROJECTION = new String[]{"_data"};
        private final Context context;
        private final ModelLoader<File, DataT> fileDelegate;
        private final ModelLoader<Uri, DataT> uriDelegate;
        private final Uri uri;
        private final int width;
        private final int height;
        private final Options options;
        private final Class<DataT> dataClass;
        private volatile boolean isCancelled;
        @Nullable
        private volatile DataFetcher<DataT> delegate;

        QMediaStoreUriFetcher(Context context, ModelLoader<File, DataT> fileDelegate, ModelLoader<Uri, DataT> uriDelegate, Uri uri, int width, int height, Options options, Class<DataT> dataClass) {
            this.context = context.getApplicationContext();
            this.fileDelegate = fileDelegate;
            this.uriDelegate = uriDelegate;
            this.uri = uri;
            this.width = width;
            this.height = height;
            this.options = options;
            this.dataClass = dataClass;
        }

        @Override
        public void loadData(@NonNull Priority priority, @NonNull DataFetcher.DataCallback<? super DataT> callback) {
            try {
                DataFetcher<DataT> local = this.buildDelegateFetcher();
                if (local == null) {
                    callback.onLoadFailed(new IllegalArgumentException("Failed to build fetcher for: " + this.uri));
                    return;
                }
                this.delegate = local;
                if (this.isCancelled) {
                    this.cancel();
                } else {
                    local.loadData(priority, callback);
                }
            }
            catch (FileNotFoundException e) {
                callback.onLoadFailed(e);
            }
        }

        @Nullable
        private DataFetcher<DataT> buildDelegateFetcher() throws FileNotFoundException {
            ModelLoader.LoadData<DataT> result = this.buildDelegateData();
            return result != null ? result.fetcher : null;
        }

        @Nullable
        private ModelLoader.LoadData<DataT> buildDelegateData() throws FileNotFoundException {
            if (Environment.isExternalStorageLegacy()) {
                return this.fileDelegate.buildLoadData(this.queryForFilePath(this.uri), this.width, this.height, this.options);
            }
            Uri toLoad = this.isAccessMediaLocationGranted() ? MediaStore.setRequireOriginal((Uri)this.uri) : this.uri;
            return this.uriDelegate.buildLoadData(toLoad, this.width, this.height, this.options);
        }

        @Override
        public void cleanup() {
            DataFetcher<DataT> local = this.delegate;
            if (local != null) {
                local.cleanup();
            }
        }

        @Override
        public void cancel() {
            this.isCancelled = true;
            DataFetcher<DataT> local = this.delegate;
            if (local != null) {
                local.cancel();
            }
        }

        @Override
        @NonNull
        public Class<DataT> getDataClass() {
            return this.dataClass;
        }

        @Override
        @NonNull
        public DataSource getDataSource() {
            return DataSource.LOCAL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        private File queryForFilePath(Uri uri) throws FileNotFoundException {
            try (Cursor cursor = null;){
                cursor = this.context.getContentResolver().query(uri, PROJECTION, null, null, null);
                if (cursor == null || !cursor.moveToFirst()) {
                    throw new FileNotFoundException("Failed to media store entry for: " + uri);
                }
                String path = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                if (TextUtils.isEmpty((CharSequence)path)) {
                    throw new FileNotFoundException("File path was empty in media store for: " + uri);
                }
                File file = new File(path);
                return file;
            }
        }

        private boolean isAccessMediaLocationGranted() {
            return this.context.checkSelfPermission("android.permission.ACCESS_MEDIA_LOCATION") == 0;
        }
    }
}

