/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request;

import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.RequestCoordinator;

public class ThumbnailRequestCoordinator
implements RequestCoordinator,
Request {
    @Nullable
    private final RequestCoordinator parent;
    private final Object requestLock;
    private volatile Request full;
    private volatile Request thumb;
    @GuardedBy(value="requestLock")
    private RequestCoordinator.RequestState fullState = RequestCoordinator.RequestState.CLEARED;
    @GuardedBy(value="requestLock")
    private RequestCoordinator.RequestState thumbState = RequestCoordinator.RequestState.CLEARED;
    @GuardedBy(value="requestLock")
    private boolean isRunningDuringBegin;

    public ThumbnailRequestCoordinator(Object requestLock, @Nullable RequestCoordinator parent) {
        this.requestLock = requestLock;
        this.parent = parent;
    }

    public void setRequests(Request full, Request thumb) {
        this.full = full;
        this.thumb = thumb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canSetImage(Request request) {
        Object object = this.requestLock;
        synchronized (object) {
            return this.parentCanSetImage() && (request.equals(this.full) || this.fullState != RequestCoordinator.RequestState.SUCCESS);
        }
    }

    @GuardedBy(value="requestLock")
    private boolean parentCanSetImage() {
        return this.parent == null || this.parent.canSetImage(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canNotifyStatusChanged(Request request) {
        Object object = this.requestLock;
        synchronized (object) {
            return this.parentCanNotifyStatusChanged() && request.equals(this.full) && !this.isAnyResourceSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canNotifyCleared(Request request) {
        Object object = this.requestLock;
        synchronized (object) {
            return this.parentCanNotifyCleared() && request.equals(this.full) && this.fullState != RequestCoordinator.RequestState.PAUSED;
        }
    }

    @GuardedBy(value="requestLock")
    private boolean parentCanNotifyCleared() {
        return this.parent == null || this.parent.canNotifyCleared(this);
    }

    @GuardedBy(value="requestLock")
    private boolean parentCanNotifyStatusChanged() {
        return this.parent == null || this.parent.canNotifyStatusChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAnyResourceSet() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.thumb.isAnyResourceSet() || this.full.isAnyResourceSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequestSuccess(Request request) {
        Object object = this.requestLock;
        synchronized (object) {
            if (request.equals(this.thumb)) {
                this.thumbState = RequestCoordinator.RequestState.SUCCESS;
                return;
            }
            this.fullState = RequestCoordinator.RequestState.SUCCESS;
            if (this.parent != null) {
                this.parent.onRequestSuccess(this);
            }
            if (!this.thumbState.isComplete()) {
                this.thumb.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequestFailed(Request request) {
        Object object = this.requestLock;
        synchronized (object) {
            if (!request.equals(this.full)) {
                this.thumbState = RequestCoordinator.RequestState.FAILED;
                return;
            }
            this.fullState = RequestCoordinator.RequestState.FAILED;
            if (this.parent != null) {
                this.parent.onRequestFailed(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestCoordinator getRoot() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.parent != null ? this.parent.getRoot() : this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin() {
        Object object = this.requestLock;
        synchronized (object) {
            this.isRunningDuringBegin = true;
            try {
                if (this.fullState != RequestCoordinator.RequestState.SUCCESS && this.thumbState != RequestCoordinator.RequestState.RUNNING) {
                    this.thumbState = RequestCoordinator.RequestState.RUNNING;
                    this.thumb.begin();
                }
                if (this.isRunningDuringBegin && this.fullState != RequestCoordinator.RequestState.RUNNING) {
                    this.fullState = RequestCoordinator.RequestState.RUNNING;
                    this.full.begin();
                }
            }
            finally {
                this.isRunningDuringBegin = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.requestLock;
        synchronized (object) {
            this.isRunningDuringBegin = false;
            this.fullState = RequestCoordinator.RequestState.CLEARED;
            this.thumbState = RequestCoordinator.RequestState.CLEARED;
            this.thumb.clear();
            this.full.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.requestLock;
        synchronized (object) {
            if (!this.thumbState.isComplete()) {
                this.thumbState = RequestCoordinator.RequestState.PAUSED;
                this.thumb.pause();
            }
            if (!this.fullState.isComplete()) {
                this.fullState = RequestCoordinator.RequestState.PAUSED;
                this.full.pause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.fullState == RequestCoordinator.RequestState.RUNNING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.fullState == RequestCoordinator.RequestState.SUCCESS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCleared() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.fullState == RequestCoordinator.RequestState.CLEARED;
        }
    }

    @Override
    public boolean isEquivalentTo(Request o) {
        if (o instanceof ThumbnailRequestCoordinator) {
            ThumbnailRequestCoordinator that = (ThumbnailRequestCoordinator)o;
            return (this.full == null ? that.full == null : this.full.isEquivalentTo(that.full)) && (this.thumb == null ? that.thumb == null : this.thumb.isEquivalentTo(that.thumb));
        }
        return false;
    }
}

