/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.UtcDates;
import java.util.Arrays;

public class DateValidatorPointForward
implements CalendarConstraints.DateValidator {
    private final long point;
    public static final Parcelable.Creator<DateValidatorPointForward> CREATOR = new Parcelable.Creator<DateValidatorPointForward>(){

        @NonNull
        public DateValidatorPointForward createFromParcel(@NonNull Parcel source) {
            return new DateValidatorPointForward(source.readLong());
        }

        @NonNull
        public DateValidatorPointForward[] newArray(int size) {
            return new DateValidatorPointForward[size];
        }
    };

    private DateValidatorPointForward(long point) {
        this.point = point;
    }

    @NonNull
    public static DateValidatorPointForward from(long point) {
        return new DateValidatorPointForward(point);
    }

    @NonNull
    public static DateValidatorPointForward now() {
        return DateValidatorPointForward.from(UtcDates.getTodayCalendar().getTimeInMillis());
    }

    @Override
    public boolean isValid(long date) {
        return date >= this.point;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeLong(this.point);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateValidatorPointForward)) {
            return false;
        }
        DateValidatorPointForward that = (DateValidatorPointForward)o;
        return this.point == that.point;
    }

    public int hashCode() {
        Object[] hashedFields = new Object[]{this.point};
        return Arrays.hashCode(hashedFields);
    }
}

