/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout;

import android.annotation.SuppressLint;
import android.app.Activity;
import androidx.annotation.GuardedBy;
import androidx.window.extensions.layout.WindowLayoutComponent;
import androidx.window.layout.ExtensionsWindowLayoutInfoAdapter;
import androidx.window.layout.WindowBackend;
import androidx.window.layout.WindowLayoutInfo;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0016\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016R\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/window/layout/ExtensionWindowLayoutInfoBackend;", "Landroidx/window/layout/WindowBackend;", "component", "Landroidx/window/extensions/layout/WindowLayoutComponent;", "(Landroidx/window/extensions/layout/WindowLayoutComponent;)V", "activityToListeners", "", "Landroid/app/Activity;", "Landroidx/window/layout/ExtensionWindowLayoutInfoBackend$MulticastConsumer;", "extensionWindowBackendLock", "Ljava/util/concurrent/locks/ReentrantLock;", "listenerToActivity", "Landroidx/core/util/Consumer;", "Landroidx/window/layout/WindowLayoutInfo;", "registerLayoutChangeCallback", "", "activity", "executor", "Ljava/util/concurrent/Executor;", "callback", "unregisterLayoutChangeCallback", "MulticastConsumer", "window_release"})
public final class ExtensionWindowLayoutInfoBackend
implements WindowBackend {
    @NotNull
    private final WindowLayoutComponent component;
    @NotNull
    private final ReentrantLock extensionWindowBackendLock;
    @GuardedBy(value="lock")
    @NotNull
    private final Map<Activity, MulticastConsumer> activityToListeners;
    @GuardedBy(value="lock")
    @NotNull
    private final Map<androidx.core.util.Consumer<WindowLayoutInfo>, Activity> listenerToActivity;

    public ExtensionWindowLayoutInfoBackend(@NotNull WindowLayoutComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.component = component;
        this.extensionWindowBackendLock = new ReentrantLock();
        this.activityToListeners = new LinkedHashMap();
        this.listenerToActivity = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLayoutChangeCallback(@NotNull Activity activity, @NotNull Executor executor, @NotNull androidx.core.util.Consumer<WindowLayoutInfo> callback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Lock lock = this.extensionWindowBackendLock;
        lock.lock();
        try {
            Unit unit;
            Unit unit2;
            boolean bl = false;
            MulticastConsumer multicastConsumer = this.activityToListeners.get(activity);
            if (multicastConsumer == null) {
                unit2 = null;
            } else {
                MulticastConsumer listener = multicastConsumer;
                boolean bl2 = false;
                listener.addListener(callback);
                this.listenerToActivity.put(callback, activity);
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit == null) {
                ExtensionWindowLayoutInfoBackend $this$registerLayoutChangeCallback_u24lambda_u2d2_u24lambda_u2d1 = this;
                boolean bl3 = false;
                MulticastConsumer consumer = new MulticastConsumer(activity);
                $this$registerLayoutChangeCallback_u24lambda_u2d2_u24lambda_u2d1.activityToListeners.put(activity, consumer);
                $this$registerLayoutChangeCallback_u24lambda_u2d2_u24lambda_u2d1.listenerToActivity.put(callback, activity);
                consumer.addListener(callback);
                $this$registerLayoutChangeCallback_u24lambda_u2d2_u24lambda_u2d1.component.addWindowLayoutInfoListener(activity, (Consumer)consumer);
            }
            Unit unit3 = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterLayoutChangeCallback(@NotNull androidx.core.util.Consumer<WindowLayoutInfo> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Lock lock = this.extensionWindowBackendLock;
        lock.lock();
        try {
            MulticastConsumer multicastConsumer;
            Activity activity;
            boolean bl = false;
            if (this.listenerToActivity.get(callback) == null) {
                return;
            }
            Activity activity2 = activity;
            if (this.activityToListeners.get(activity2) == null) {
                return;
            }
            MulticastConsumer multicastListener = multicastConsumer;
            multicastListener.removeListener(callback);
            if (multicastListener.isEmpty()) {
                this.component.removeWindowLayoutInfoListener((Consumer)multicastListener);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0014\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\fJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/window/layout/ExtensionWindowLayoutInfoBackend$MulticastConsumer;", "Ljava/util/function/Consumer;", "Landroidx/window/extensions/layout/WindowLayoutInfo;", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "lastKnownValue", "Landroidx/window/layout/WindowLayoutInfo;", "multicastConsumerLock", "Ljava/util/concurrent/locks/ReentrantLock;", "registeredListeners", "", "Landroidx/core/util/Consumer;", "accept", "", "value", "addListener", "listener", "isEmpty", "", "removeListener", "window_release"})
    @SuppressLint(value={"NewApi"})
    private static final class MulticastConsumer
    implements Consumer<androidx.window.extensions.layout.WindowLayoutInfo> {
        @NotNull
        private final Activity activity;
        @NotNull
        private final ReentrantLock multicastConsumerLock;
        @GuardedBy(value="lock")
        @Nullable
        private WindowLayoutInfo lastKnownValue;
        @GuardedBy(value="lock")
        @NotNull
        private final Set<androidx.core.util.Consumer<WindowLayoutInfo>> registeredListeners;

        public MulticastConsumer(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.activity = activity;
            this.multicastConsumerLock = new ReentrantLock();
            this.registeredListeners = new LinkedHashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(@NotNull androidx.window.extensions.layout.WindowLayoutInfo value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Lock lock = this.multicastConsumerLock;
            lock.lock();
            try {
                boolean bl = false;
                this.lastKnownValue = ExtensionsWindowLayoutInfoAdapter.INSTANCE.translate$window_release(this.activity, value);
                Iterable $this$forEach$iv = this.registeredListeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    androidx.core.util.Consumer consumer = (androidx.core.util.Consumer)element$iv;
                    boolean bl2 = false;
                    consumer.accept((Object)this.lastKnownValue);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addListener(@NotNull androidx.core.util.Consumer<WindowLayoutInfo> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            Lock lock = this.multicastConsumerLock;
            lock.lock();
            try {
                boolean bl = false;
                WindowLayoutInfo windowLayoutInfo2 = this.lastKnownValue;
                if (windowLayoutInfo2 != null) {
                    WindowLayoutInfo value = windowLayoutInfo2;
                    boolean bl2 = false;
                    listener.accept((Object)value);
                }
                boolean bl3 = this.registeredListeners.add(listener);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeListener(@NotNull androidx.core.util.Consumer<WindowLayoutInfo> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            Lock lock = this.multicastConsumerLock;
            lock.lock();
            try {
                boolean bl = false;
                boolean bl2 = this.registeredListeners.remove(listener);
            }
            finally {
                lock.unlock();
            }
        }

        public final boolean isEmpty() {
            return this.registeredListeners.isEmpty();
        }
    }
}

