/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPoolAdapter;
import com.bumptech.glide.load.resource.ImageDecoderResourceDecoder;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import java.io.IOException;

@RequiresApi(api=28)
public final class BitmapImageDecoderResourceDecoder
extends ImageDecoderResourceDecoder<Bitmap> {
    private static final String TAG = "BitmapImageDecoder";
    private final BitmapPool bitmapPool = new BitmapPoolAdapter();

    @Override
    protected Resource<Bitmap> decode(ImageDecoder.Source source, int requestedResourceWidth, int requestedResourceHeight, ImageDecoder.OnHeaderDecodedListener listener) throws IOException {
        Bitmap result = ImageDecoder.decodeBitmap((ImageDecoder.Source)source, (ImageDecoder.OnHeaderDecodedListener)listener);
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Decoded [" + result.getWidth() + "x" + result.getHeight() + "] for [" + requestedResourceWidth + "x" + requestedResourceHeight + "]"));
        }
        return new BitmapResource(result, this.bitmapPool);
    }
}

