/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.bumptech.glide.load.engine.Resource;

class ResourceRecycler {
    private boolean isRecycling;
    private final Handler handler = new Handler(Looper.getMainLooper(), (Handler.Callback)new ResourceRecyclerCallback());

    ResourceRecycler() {
    }

    synchronized void recycle(Resource<?> resource, boolean forceNextFrame) {
        if (this.isRecycling || forceNextFrame) {
            this.handler.obtainMessage(1, resource).sendToTarget();
        } else {
            this.isRecycling = true;
            resource.recycle();
            this.isRecycling = false;
        }
    }

    private static final class ResourceRecyclerCallback
    implements Handler.Callback {
        static final int RECYCLE_RESOURCE = 1;

        ResourceRecyclerCallback() {
        }

        public boolean handleMessage(Message message) {
            if (message.what == 1) {
                Resource resource = (Resource)message.obj;
                resource.recycle();
                return true;
            }
            return false;
        }
    }
}

